/*
 * Decompiled with CFR 0.152.
 */
package org.opensciencegrid.authz.xacml.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.Subject;
import org.apache.axis.MessageContext;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.signature.XMLSignature;
import org.globus.gsi.CertUtil;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.globus.util.I18n;
import org.globus.wsrf.config.ConfigException;
import org.ietf.jgss.GSSCredential;

class CredentialUtil {
    private static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.error", (ClassLoader)CredentialUtil.class.getClassLoader());

    CredentialUtil() {
    }

    public static GSSCredential getCredential(MessageContext messageContext) throws SecurityException {
        Object object = messageContext.getProperty("org.globus.gsi.credentials");
        if (object == null || object instanceof GSSCredential) {
            return (GSSCredential)object;
        }
        throw new SecurityException(i18n.getMessage("invalidType", new Object[]{"org.globus.gsi.credentials", GSSCredential.class.getName()}));
    }

    public static String getIdentity(Subject subject) {
        if (subject == null) {
            return null;
        }
        Set<GlobusPrincipal> set = subject.getPrincipals(GlobusPrincipal.class);
        if (set == null || set.isEmpty()) {
            return null;
        }
        Iterator<GlobusPrincipal> iterator = set.iterator();
        GlobusPrincipal globusPrincipal = iterator.next();
        return globusPrincipal.toString();
    }

    public static X509Certificate[] getCertificates(XMLSignature xMLSignature) throws Exception {
        KeyInfo keyInfo = xMLSignature.getKeyInfo();
        return CredentialUtil.getCertificatesX509Data(keyInfo);
    }

    public static X509Certificate[] getCertificatesX509Data(KeyInfo keyInfo) throws Exception {
        int n = keyInfo.lengthX509Data();
        if (n != 1) {
            throw new ConfigException(i18n.getMessage("invalidX509Data", new Object[]{new Integer(n)}));
        }
        X509Data x509Data = keyInfo.itemX509Data(0);
        int n2 = x509Data.lengthCertificate();
        if (n2 <= 0) {
            throw new ConfigException(i18n.getMessage("invalidCertData", new Object[]{new Integer(n2)}));
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[n2];
        for (int i = 0; i < n2; ++i) {
            XMLX509Certificate xMLX509Certificate = x509Data.itemCertificate(i);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xMLX509Certificate.getCertificateBytes());
            x509CertificateArray[i] = CertUtil.loadCertificate((InputStream)byteArrayInputStream);
        }
        return x509CertificateArray;
    }

    public static Calendar[] getValidity(X509Certificate[] x509CertificateArray) {
        Comparable<Date> comparable;
        if (x509CertificateArray == null || x509CertificateArray.length < 1) {
            return null;
        }
        Comparable<Date> comparable2 = x509CertificateArray[0].getNotAfter();
        Date date = x509CertificateArray[0].getNotBefore();
        for (int i = 1; i < x509CertificateArray.length; ++i) {
            Date date2;
            comparable = x509CertificateArray[i].getNotAfter();
            if (((Date)comparable).before((Date)comparable2)) {
                comparable2 = comparable;
            }
            if (!(date2 = x509CertificateArray[i].getNotBefore()).after(date)) continue;
            date = date2;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)comparable2);
        comparable = Calendar.getInstance();
        ((Calendar)comparable).setTime(date);
        return new Calendar[]{calendar, comparable};
    }

    public static Principal getPrincipal(Subject subject) {
        if (subject == null) {
            return null;
        }
        Set<Principal> set = subject.getPrincipals();
        if (set == null || set.isEmpty()) {
            return null;
        }
        return set.iterator().next();
    }

    public static String getIdentity(X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray != null && x509CertificateArray.length > 0) {
            return x509CertificateArray[x509CertificateArray.length - 1].getSubjectDN().getName();
        }
        return null;
    }

    public static void writeSubject(Subject subject, ObjectOutputStream objectOutputStream) throws SecurityException {
        try {
            Collection<Object> collection;
            objectOutputStream.writeObject(subject);
            if (subject == null) {
                return;
            }
            Set<Object> set = subject.getPublicCredentials();
            if (set != null && !set.isEmpty()) {
                objectOutputStream.writeObject(Boolean.TRUE);
                collection = new Vector<Object>(set);
                objectOutputStream.writeObject(collection);
            } else {
                objectOutputStream.writeObject(Boolean.FALSE);
            }
            collection = subject.getPrivateCredentials();
            if (collection != null && !collection.isEmpty()) {
                objectOutputStream.writeObject(Boolean.TRUE);
                Vector<Object> vector = new Vector<Object>(collection);
                objectOutputStream.writeObject(vector);
            } else {
                objectOutputStream.writeObject(Boolean.FALSE);
            }
        }
        catch (IOException iOException) {
            throw new SecurityException(iOException);
        }
    }

    public static Subject readSubject(ObjectInputStream objectInputStream) throws SecurityException, ClassNotFoundException {
        try {
            Serializable serializable;
            Subject subject = (Subject)objectInputStream.readObject();
            if (subject == null) {
                return subject;
            }
            Subject subject2 = null;
            if (subject.isReadOnly()) {
                subject2 = new Subject();
                subject2.getPrincipals().addAll(subject.getPrincipals());
            } else {
                subject2 = subject;
            }
            Boolean bl = (Boolean)objectInputStream.readObject();
            if (Boolean.TRUE.equals(bl)) {
                serializable = (Vector)objectInputStream.readObject();
                subject2.getPublicCredentials().addAll((Collection<Object>)((Object)serializable));
            }
            if (Boolean.TRUE.equals(serializable = (Boolean)objectInputStream.readObject())) {
                Vector vector = (Vector)objectInputStream.readObject();
                subject2.getPrivateCredentials().addAll(vector);
            }
            if (subject.isReadOnly()) {
                subject2.setReadOnly();
            }
            return subject2;
        }
        catch (IOException iOException) {
            throw new SecurityException(iOException);
        }
    }
}

