/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.context.httpinvoker;

import java.io.IOException;
import java.net.HttpURLConnection;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationCredentialsNotFoundException;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.remoting.httpinvoker.SimpleHttpInvokerRequestExecutor;

public class AuthenticationSimpleHttpInvokerRequestExecutor
extends SimpleHttpInvokerRequestExecutor {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$context$httpinvoker$AuthenticationSimpleHttpInvokerRequestExecutor == null ? (class$org$acegisecurity$context$httpinvoker$AuthenticationSimpleHttpInvokerRequestExecutor = AuthenticationSimpleHttpInvokerRequestExecutor.class$("org.acegisecurity.context.httpinvoker.AuthenticationSimpleHttpInvokerRequestExecutor")) : class$org$acegisecurity$context$httpinvoker$AuthenticationSimpleHttpInvokerRequestExecutor));
    static /* synthetic */ Class class$org$acegisecurity$context$httpinvoker$AuthenticationSimpleHttpInvokerRequestExecutor;

    protected void doPrepareConnection(HttpURLConnection con, int contentLength) throws IOException {
    }

    protected void prepareConnection(HttpURLConnection con, int contentLength) throws IOException, AuthenticationCredentialsNotFoundException {
        super.prepareConnection(con, contentLength);
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && auth.getName() != null && auth.getCredentials() != null) {
            String base64 = auth.getName() + ":" + auth.getCredentials().toString();
            con.setRequestProperty("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])base64.getBytes())));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("HttpInvocation now presenting via BASIC authentication SecurityContextHolder-derived: " + auth.toString()));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unable to set BASIC authentication header as SecurityContext did not provide valid Authentication: " + auth));
        }
        this.doPrepareConnection(con, contentLength);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

