/*
 * Decompiled with CFR 0.152.
 */
package alluxio.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class PartitionInfo
implements TBase<PartitionInfo, _Fields>,
Serializable,
Cloneable,
Comparable<PartitionInfo> {
    private static final TStruct STRUCT_DESC = new TStruct("PartitionInfo");
    private static final TField KEY_START_FIELD_DESC = new TField("keyStart", 11, 1);
    private static final TField KEY_LIMIT_FIELD_DESC = new TField("keyLimit", 11, 2);
    private static final TField BLOCK_ID_FIELD_DESC = new TField("blockId", 10, 3);
    private static final TField KEY_COUNT_FIELD_DESC = new TField("keyCount", 8, 4);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private ByteBuffer keyStart;
    private ByteBuffer keyLimit;
    private long blockId;
    private int keyCount;
    private static final int __BLOCKID_ISSET_ID = 0;
    private static final int __KEYCOUNT_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public PartitionInfo() {
    }

    public PartitionInfo(ByteBuffer keyStart, ByteBuffer keyLimit, long blockId, int keyCount) {
        this();
        this.keyStart = TBaseHelper.copyBinary((ByteBuffer)keyStart);
        this.keyLimit = TBaseHelper.copyBinary((ByteBuffer)keyLimit);
        this.blockId = blockId;
        this.setBlockIdIsSet(true);
        this.keyCount = keyCount;
        this.setKeyCountIsSet(true);
    }

    public PartitionInfo(PartitionInfo other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetKeyStart()) {
            this.keyStart = TBaseHelper.copyBinary((ByteBuffer)other.keyStart);
        }
        if (other.isSetKeyLimit()) {
            this.keyLimit = TBaseHelper.copyBinary((ByteBuffer)other.keyLimit);
        }
        this.blockId = other.blockId;
        this.keyCount = other.keyCount;
    }

    public PartitionInfo deepCopy() {
        return new PartitionInfo(this);
    }

    public void clear() {
        this.keyStart = null;
        this.keyLimit = null;
        this.setBlockIdIsSet(false);
        this.blockId = 0L;
        this.setKeyCountIsSet(false);
        this.keyCount = 0;
    }

    public byte[] getKeyStart() {
        this.setKeyStart(TBaseHelper.rightSize((ByteBuffer)this.keyStart));
        return this.keyStart == null ? null : this.keyStart.array();
    }

    public ByteBuffer bufferForKeyStart() {
        return TBaseHelper.copyBinary((ByteBuffer)this.keyStart);
    }

    public PartitionInfo setKeyStart(byte[] keyStart) {
        this.keyStart = keyStart == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(keyStart, keyStart.length));
        return this;
    }

    public PartitionInfo setKeyStart(ByteBuffer keyStart) {
        this.keyStart = TBaseHelper.copyBinary((ByteBuffer)keyStart);
        return this;
    }

    public void unsetKeyStart() {
        this.keyStart = null;
    }

    public boolean isSetKeyStart() {
        return this.keyStart != null;
    }

    public void setKeyStartIsSet(boolean value) {
        if (!value) {
            this.keyStart = null;
        }
    }

    public byte[] getKeyLimit() {
        this.setKeyLimit(TBaseHelper.rightSize((ByteBuffer)this.keyLimit));
        return this.keyLimit == null ? null : this.keyLimit.array();
    }

    public ByteBuffer bufferForKeyLimit() {
        return TBaseHelper.copyBinary((ByteBuffer)this.keyLimit);
    }

    public PartitionInfo setKeyLimit(byte[] keyLimit) {
        this.keyLimit = keyLimit == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(keyLimit, keyLimit.length));
        return this;
    }

    public PartitionInfo setKeyLimit(ByteBuffer keyLimit) {
        this.keyLimit = TBaseHelper.copyBinary((ByteBuffer)keyLimit);
        return this;
    }

    public void unsetKeyLimit() {
        this.keyLimit = null;
    }

    public boolean isSetKeyLimit() {
        return this.keyLimit != null;
    }

    public void setKeyLimitIsSet(boolean value) {
        if (!value) {
            this.keyLimit = null;
        }
    }

    public long getBlockId() {
        return this.blockId;
    }

    public PartitionInfo setBlockId(long blockId) {
        this.blockId = blockId;
        this.setBlockIdIsSet(true);
        return this;
    }

    public void unsetBlockId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetBlockId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setBlockIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int getKeyCount() {
        return this.keyCount;
    }

    public PartitionInfo setKeyCount(int keyCount) {
        this.keyCount = keyCount;
        this.setKeyCountIsSet(true);
        return this;
    }

    public void unsetKeyCount() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetKeyCount() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setKeyCountIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case KEY_START: {
                if (value == null) {
                    this.unsetKeyStart();
                    break;
                }
                this.setKeyStart((ByteBuffer)value);
                break;
            }
            case KEY_LIMIT: {
                if (value == null) {
                    this.unsetKeyLimit();
                    break;
                }
                this.setKeyLimit((ByteBuffer)value);
                break;
            }
            case BLOCK_ID: {
                if (value == null) {
                    this.unsetBlockId();
                    break;
                }
                this.setBlockId((Long)value);
                break;
            }
            case KEY_COUNT: {
                if (value == null) {
                    this.unsetKeyCount();
                    break;
                }
                this.setKeyCount((Integer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case KEY_START: {
                return this.getKeyStart();
            }
            case KEY_LIMIT: {
                return this.getKeyLimit();
            }
            case BLOCK_ID: {
                return this.getBlockId();
            }
            case KEY_COUNT: {
                return this.getKeyCount();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case KEY_START: {
                return this.isSetKeyStart();
            }
            case KEY_LIMIT: {
                return this.isSetKeyLimit();
            }
            case BLOCK_ID: {
                return this.isSetBlockId();
            }
            case KEY_COUNT: {
                return this.isSetKeyCount();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof PartitionInfo) {
            return this.equals((PartitionInfo)that);
        }
        return false;
    }

    public boolean equals(PartitionInfo that) {
        if (that == null) {
            return false;
        }
        boolean this_present_keyStart = this.isSetKeyStart();
        boolean that_present_keyStart = that.isSetKeyStart();
        if (this_present_keyStart || that_present_keyStart) {
            if (!this_present_keyStart || !that_present_keyStart) {
                return false;
            }
            if (!this.keyStart.equals(that.keyStart)) {
                return false;
            }
        }
        boolean this_present_keyLimit = this.isSetKeyLimit();
        boolean that_present_keyLimit = that.isSetKeyLimit();
        if (this_present_keyLimit || that_present_keyLimit) {
            if (!this_present_keyLimit || !that_present_keyLimit) {
                return false;
            }
            if (!this.keyLimit.equals(that.keyLimit)) {
                return false;
            }
        }
        boolean this_present_blockId = true;
        boolean that_present_blockId = true;
        if (this_present_blockId || that_present_blockId) {
            if (!this_present_blockId || !that_present_blockId) {
                return false;
            }
            if (this.blockId != that.blockId) {
                return false;
            }
        }
        boolean this_present_keyCount = true;
        boolean that_present_keyCount = true;
        if (this_present_keyCount || that_present_keyCount) {
            if (!this_present_keyCount || !that_present_keyCount) {
                return false;
            }
            if (this.keyCount != that.keyCount) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Comparable<Boolean>> list = new ArrayList<Comparable<Boolean>>();
        boolean present_keyStart = this.isSetKeyStart();
        list.add(Boolean.valueOf(present_keyStart));
        if (present_keyStart) {
            list.add(this.keyStart);
        }
        boolean present_keyLimit = this.isSetKeyLimit();
        list.add(Boolean.valueOf(present_keyLimit));
        if (present_keyLimit) {
            list.add(this.keyLimit);
        }
        boolean present_blockId = true;
        list.add(Boolean.valueOf(present_blockId));
        if (present_blockId) {
            list.add(Long.valueOf(this.blockId));
        }
        boolean present_keyCount = true;
        list.add(Boolean.valueOf(present_keyCount));
        if (present_keyCount) {
            list.add(Integer.valueOf(this.keyCount));
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(PartitionInfo other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetKeyStart()).compareTo(other.isSetKeyStart());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKeyStart() && (lastComparison = TBaseHelper.compareTo((Comparable)this.keyStart, (Comparable)other.keyStart)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetKeyLimit()).compareTo(other.isSetKeyLimit());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKeyLimit() && (lastComparison = TBaseHelper.compareTo((Comparable)this.keyLimit, (Comparable)other.keyLimit)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetBlockId()).compareTo(other.isSetBlockId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBlockId() && (lastComparison = TBaseHelper.compareTo((long)this.blockId, (long)other.blockId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetKeyCount()).compareTo(other.isSetKeyCount());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKeyCount() && (lastComparison = TBaseHelper.compareTo((int)this.keyCount, (int)other.keyCount)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PartitionInfo(");
        boolean first = true;
        sb.append("keyStart:");
        if (this.keyStart == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.keyStart, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("keyLimit:");
        if (this.keyLimit == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.keyLimit, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("blockId:");
        sb.append(this.blockId);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("keyCount:");
        sb.append(this.keyCount);
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new PartitionInfoStandardSchemeFactory());
        schemes.put(TupleScheme.class, new PartitionInfoTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.KEY_START, new FieldMetaData("keyStart", 3, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.KEY_LIMIT, new FieldMetaData("keyLimit", 3, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.BLOCK_ID, new FieldMetaData("blockId", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.KEY_COUNT, new FieldMetaData("keyCount", 3, new FieldValueMetaData(8)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(PartitionInfo.class, metaDataMap);
    }

    private static class PartitionInfoTupleScheme
    extends TupleScheme<PartitionInfo> {
        private PartitionInfoTupleScheme() {
        }

        public void write(TProtocol prot, PartitionInfo struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetKeyStart()) {
                optionals.set(0);
            }
            if (struct.isSetKeyLimit()) {
                optionals.set(1);
            }
            if (struct.isSetBlockId()) {
                optionals.set(2);
            }
            if (struct.isSetKeyCount()) {
                optionals.set(3);
            }
            oprot.writeBitSet(optionals, 4);
            if (struct.isSetKeyStart()) {
                oprot.writeBinary(struct.keyStart);
            }
            if (struct.isSetKeyLimit()) {
                oprot.writeBinary(struct.keyLimit);
            }
            if (struct.isSetBlockId()) {
                oprot.writeI64(struct.blockId);
            }
            if (struct.isSetKeyCount()) {
                oprot.writeI32(struct.keyCount);
            }
        }

        public void read(TProtocol prot, PartitionInfo struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(4);
            if (incoming.get(0)) {
                struct.keyStart = iprot.readBinary();
                struct.setKeyStartIsSet(true);
            }
            if (incoming.get(1)) {
                struct.keyLimit = iprot.readBinary();
                struct.setKeyLimitIsSet(true);
            }
            if (incoming.get(2)) {
                struct.blockId = iprot.readI64();
                struct.setBlockIdIsSet(true);
            }
            if (incoming.get(3)) {
                struct.keyCount = iprot.readI32();
                struct.setKeyCountIsSet(true);
            }
        }
    }

    private static class PartitionInfoTupleSchemeFactory
    implements SchemeFactory {
        private PartitionInfoTupleSchemeFactory() {
        }

        public PartitionInfoTupleScheme getScheme() {
            return new PartitionInfoTupleScheme();
        }
    }

    private static class PartitionInfoStandardScheme
    extends StandardScheme<PartitionInfo> {
        private PartitionInfoStandardScheme() {
        }

        public void read(TProtocol iprot, PartitionInfo struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.keyStart = iprot.readBinary();
                            struct.setKeyStartIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.keyLimit = iprot.readBinary();
                            struct.setKeyLimitIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 10) {
                            struct.blockId = iprot.readI64();
                            struct.setBlockIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.keyCount = iprot.readI32();
                            struct.setKeyCountIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, PartitionInfo struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.keyStart != null) {
                oprot.writeFieldBegin(KEY_START_FIELD_DESC);
                oprot.writeBinary(struct.keyStart);
                oprot.writeFieldEnd();
            }
            if (struct.keyLimit != null) {
                oprot.writeFieldBegin(KEY_LIMIT_FIELD_DESC);
                oprot.writeBinary(struct.keyLimit);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(BLOCK_ID_FIELD_DESC);
            oprot.writeI64(struct.blockId);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(KEY_COUNT_FIELD_DESC);
            oprot.writeI32(struct.keyCount);
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class PartitionInfoStandardSchemeFactory
    implements SchemeFactory {
        private PartitionInfoStandardSchemeFactory() {
        }

        public PartitionInfoStandardScheme getScheme() {
            return new PartitionInfoStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        KEY_START(1, "keyStart"),
        KEY_LIMIT(2, "keyLimit"),
        BLOCK_ID(3, "blockId"),
        KEY_COUNT(4, "keyCount");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return KEY_START;
                }
                case 2: {
                    return KEY_LIMIT;
                }
                case 3: {
                    return BLOCK_ID;
                }
                case 4: {
                    return KEY_COUNT;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

