/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.ReadType;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.client.file.options.OpenFileOptions;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.shell.command.WithWildCardPathCommand;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class CatCommand
extends WithWildCardPathCommand {
    public CatCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "cat";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void runCommand(AlluxioURI path, CommandLine cl) throws IOException {
        block7: {
            try {
                URIStatus status = this.mFileSystem.getStatus(path);
                if (!status.isFolder()) {
                    OpenFileOptions options = OpenFileOptions.defaults().setReadType(ReadType.NO_CACHE);
                    byte[] buf = new byte[512];
                    try (FileInStream is = this.mFileSystem.openFile(path, options);){
                        int read = is.read(buf);
                        while (read != -1) {
                            System.out.write(buf, 0, read);
                            read = is.read(buf);
                        }
                        break block7;
                    }
                }
                throw new IOException(ExceptionMessage.PATH_MUST_BE_FILE.getMessage(new Object[]{path}));
            }
            catch (AlluxioException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    @Override
    public String getUsage() {
        return "cat <path>";
    }

    @Override
    public String getDescription() {
        return "Prints the file's contents to the console.";
    }
}

