/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.shell.AlluxioShellUtils;
import alluxio.shell.command.AbstractShellCommand;
import alluxio.util.io.PathUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class CopyFromLocalCommand
extends AbstractShellCommand {
    public CopyFromLocalCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "copyFromLocal";
    }

    @Override
    protected int getNumOfArgs() {
        return 2;
    }

    @Override
    public void run(CommandLine cl) throws IOException {
        String[] args = cl.getArgs();
        String srcPath = args[0];
        AlluxioURI dstPath = new AlluxioURI(args[1]);
        List<File> srcFiles = AlluxioShellUtils.getFiles(srcPath);
        if (srcFiles.size() == 0) {
            throw new IOException("Local path " + srcPath + " does not exist.");
        }
        if (srcPath.contains("*")) {
            this.copyFromLocalWildcard(srcFiles, dstPath);
        } else {
            this.copyFromLocal(new File(srcPath), dstPath);
        }
    }

    private void copyFromLocalWildcard(List<File> srcFiles, AlluxioURI dstPath) throws IOException {
        URIStatus dstStatus;
        try {
            this.mFileSystem.createDirectory(dstPath);
        }
        catch (FileAlreadyExistsException e) {
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
        try {
            dstStatus = this.mFileSystem.getStatus(dstPath);
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
        if (!dstStatus.isFolder()) {
            throw new IOException(ExceptionMessage.DESTINATION_FILE_CANNOT_EXIST_WITH_WILDCARD_SOURCE.getMessage(new Object[0]));
        }
        ArrayList errorMessages = Lists.newArrayList();
        for (File srcFile : srcFiles) {
            try {
                this.copyFromLocal(srcFile, new AlluxioURI(PathUtils.concatPath((Object)dstPath.getPath(), (Object[])new Object[]{srcFile.getName()})));
            }
            catch (IOException e) {
                errorMessages.add(e.getMessage());
            }
        }
        if (errorMessages.size() != 0) {
            throw new IOException(Joiner.on((char)'\n').join((Iterable)errorMessages));
        }
    }

    private void copyFromLocal(File srcFile, AlluxioURI dstPath) throws IOException {
        this.copyPath(srcFile, dstPath);
        System.out.println("Copied " + srcFile.getPath() + " to " + dstPath);
    }

    private void copyPath(File src, AlluxioURI dstPath) throws IOException {
        block17: {
            try {
                String[] fileList;
                if (!src.isDirectory()) {
                    if (this.mFileSystem.exists(dstPath) && this.mFileSystem.getStatus(dstPath).isFolder()) {
                        dstPath = dstPath.join(src.getName());
                    }
                    FileOutStream os = null;
                    try (Closer closer = Closer.create();){
                        os = (FileOutStream)closer.register((Closeable)this.mFileSystem.createFile(dstPath));
                        FileInputStream in = (FileInputStream)closer.register((Closeable)new FileInputStream(src));
                        FileChannel channel = (FileChannel)closer.register((Closeable)in.getChannel());
                        ByteBuffer buf = ByteBuffer.allocate(0x800000);
                        while (channel.read(buf) != -1) {
                            buf.flip();
                            os.write(buf.array(), 0, buf.limit());
                        }
                        break block17;
                    }
                }
                this.mFileSystem.createDirectory(dstPath);
                ArrayList errorMessages = Lists.newArrayList();
                for (String file : fileList = src.list()) {
                    AlluxioURI newPath = new AlluxioURI(dstPath, new AlluxioURI(file));
                    File srcFile = new File(src, file);
                    try {
                        this.copyPath(srcFile, newPath);
                    }
                    catch (IOException e) {
                        errorMessages.add(e.getMessage());
                    }
                }
                if (errorMessages.size() != 0) {
                    if (errorMessages.size() == fileList.length && this.mFileSystem.exists(dstPath)) {
                        this.mFileSystem.delete(dstPath);
                    }
                    throw new IOException(Joiner.on((char)'\n').join((Iterable)errorMessages));
                }
            }
            catch (AlluxioException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    @Override
    public String getUsage() {
        return "copyFromLocal <src> <remoteDst>";
    }

    @Override
    public String getDescription() {
        return "Copies a file or a directory from local filesystem to Alluxio filesystem.";
    }
}

