/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import alluxio.shell.command.WithWildCardPathCommand;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class DuCommand
extends WithWildCardPathCommand {
    public DuCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "du";
    }

    @Override
    void runCommand(AlluxioURI path, CommandLine cl) throws IOException {
        long sizeInBytes = this.getFileOrFolderSize(this.mFileSystem, path);
        System.out.println(path + " is " + sizeInBytes + " bytes");
    }

    private long getFileOrFolderSize(FileSystem fs, AlluxioURI path) throws IOException {
        List statuses;
        long sizeInBytes = 0L;
        try {
            statuses = fs.listStatus(path);
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
        for (URIStatus status : statuses) {
            if (status.isFolder()) {
                AlluxioURI subFolder = new AlluxioURI(status.getPath());
                sizeInBytes += this.getFileOrFolderSize(fs, subFolder);
                continue;
            }
            sizeInBytes += status.getLength();
        }
        return sizeInBytes;
    }

    @Override
    public String getUsage() {
        return "du <path>";
    }

    @Override
    public String getDescription() {
        return "Displays the size of the specified file or directory.";
    }
}

