/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.Configuration;
import alluxio.client.block.AlluxioBlockStore;
import alluxio.client.file.FileSystem;
import alluxio.shell.command.AbstractShellCommand;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class GetCapacityBytesCommand
extends AbstractShellCommand {
    public GetCapacityBytesCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "getCapacityBytes";
    }

    @Override
    protected int getNumOfArgs() {
        return 0;
    }

    @Override
    public void run(CommandLine cl) throws IOException {
        long capacityBytes = AlluxioBlockStore.get().getCapacityBytes();
        System.out.println("Capacity Bytes: " + capacityBytes);
    }

    @Override
    public String getUsage() {
        return "getCapacityBytes";
    }

    @Override
    public String getDescription() {
        return "Gets the capacity of the Alluxio file system.";
    }
}

