/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.shell.command.AbstractShellCommand;
import alluxio.shell.command.CommandUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class SetTtlCommand
extends AbstractShellCommand {
    public SetTtlCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "setTtl";
    }

    @Override
    protected int getNumOfArgs() {
        return 2;
    }

    @Override
    public void run(CommandLine cl) throws IOException {
        String[] args = cl.getArgs();
        long ttlMs = Long.parseLong(args[1]);
        Preconditions.checkArgument((ttlMs >= 0L ? 1 : 0) != 0, (Object)"TTL value must be >= 0");
        AlluxioURI path = new AlluxioURI(args[0]);
        CommandUtils.setTtl(this.mFileSystem, path, ttlMs);
        System.out.println("TTL of file '" + path + "' was successfully set to " + ttlMs + " milliseconds.");
    }

    @Override
    public String getUsage() {
        return "setTtl <path> <time to live(in milliseconds)>";
    }

    @Override
    public String getDescription() {
        return "Sets a new TTL value for the file at path.";
    }
}

