/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.shell.command.AbstractShellCommand;
import alluxio.shell.command.CommandUtils;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class UnsetTtlCommand
extends AbstractShellCommand {
    public UnsetTtlCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "unsetTtl";
    }

    @Override
    protected int getNumOfArgs() {
        return 1;
    }

    @Override
    public void run(CommandLine cl) throws IOException {
        String[] args = cl.getArgs();
        AlluxioURI inputPath = new AlluxioURI(args[0]);
        CommandUtils.setTtl(this.mFileSystem, inputPath, -1L);
        System.out.println("TTL of file '" + inputPath + "' was successfully removed.");
    }

    @Override
    public String getUsage() {
        return "unsetTtl <path>";
    }

    @Override
    public String getDescription() {
        return "Unsets the TTL value for the given path.";
    }
}

