/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.bean.BeanEndpoint;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanInfoCacheKey;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.LRUCacheFactory;
import org.apache.camel.util.LRUSoftCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanComponent
extends UriEndpointComponent {
    private static final Logger LOG = LoggerFactory.getLogger(BeanComponent.class);
    private final LRUSoftCache<BeanInfoCacheKey, BeanInfo> cache = LRUCacheFactory.newLRUSoftCache(1000);

    public BeanComponent() {
        super(BeanEndpoint.class);
    }

    public BeanComponent(Class<? extends Endpoint> endpointClass) {
        super(endpointClass);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        BeanEndpoint endpoint = new BeanEndpoint(uri, this);
        endpoint.setBeanName(remaining);
        this.setProperties(endpoint, parameters);
        Map<String, Object> options = IntrospectionSupport.extractProperties(parameters, "bean.");
        endpoint.setParameters(options);
        return endpoint;
    }

    BeanInfo getBeanInfoFromCache(BeanInfoCacheKey key) {
        return (BeanInfo)this.cache.get(key);
    }

    void addBeanInfoToCache(BeanInfoCacheKey key, BeanInfo beanInfo) {
        this.cache.put(key, beanInfo);
    }

    @Override
    protected void doShutdown() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Clearing BeanInfo cache[size={}, hits={}, misses={}, evicted={}]", this.cache.size(), this.cache.getHits(), this.cache.getMisses(), this.cache.getEvicted());
        }
        this.cache.clear();
    }
}

