/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonArrayBuilder;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.json.JsonString;
import org.apache.activemq.artemis.json.JsonValue;
import org.apache.activemq.artemis.utils.BufferHelper;
import org.apache.activemq.artemis.utils.JsonLoader;

public final class BridgeConfiguration
implements Serializable {
    private static final long serialVersionUID = -1057244274380572226L;
    public static String NAME = "name";
    public static String QUEUE_NAME = "queue-name";
    public static String FORWARDING_ADDRESS = "forwarding-address";
    public static String FILTER_STRING = "filter-string";
    public static String STATIC_CONNECTORS = "static-connectors";
    public static String DISCOVERY_GROUP_NAME = "discovery-group-name";
    public static String HA = "ha";
    public static String TRANSFORMER_CONFIGURATION = "transformer-configuration";
    public static String RETRY_INTERVAL = "retry-interval";
    public static String RETRY_INTERVAL_MULTIPLIER = "retry-interval-multiplier";
    public static String INITIAL_CONNECT_ATTEMPTS = "initial-connect-attempts";
    public static String RECONNECT_ATTEMPTS = "reconnect-attempts";
    public static String RECONNECT_ATTEMPTS_ON_SAME_NODE = "reconnect-attempts-on-same-node";
    public static String USE_DUPLICATE_DETECTION = "use-duplicate-detection";
    public static String CONFIRMATION_WINDOW_SIZE = "confirmation-window-size";
    public static String PRODUCER_WINDOW_SIZE = "producer-window-size";
    public static String CLIENT_FAILURE_CHECK_PERIOD = "client-failure-check-period";
    public static String USER = "user";
    public static String PASSWORD = "password";
    public static String CONNECTION_TTL = "connection-ttl";
    public static String MAX_RETRY_INTERVAL = "max-retry-interval";
    public static String MIN_LARGE_MESSAGE_SIZE = "min-large-message-size";
    public static String CALL_TIMEOUT = "call-timeout";
    public static String ROUTING_TYPE = "routing-type";
    public static String CONCURRENCY = "concurrency";
    public static String CONFIGURATION_MANAGED = "configuration-managed";
    private String name = null;
    private String queueName = null;
    private String forwardingAddress = null;
    private String filterString = null;
    private List<String> staticConnectors = null;
    private String discoveryGroupName = null;
    private boolean ha = false;
    private TransformerConfiguration transformerConfiguration = null;
    private long retryInterval = 2000L;
    private double retryIntervalMultiplier = ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER;
    private int initialConnectAttempts = ActiveMQDefaultConfiguration.getDefaultBridgeInitialConnectAttempts();
    private int reconnectAttempts = ActiveMQDefaultConfiguration.getDefaultBridgeReconnectAttempts();
    private int reconnectAttemptsOnSameNode = ActiveMQDefaultConfiguration.getDefaultBridgeConnectSameNode();
    private boolean useDuplicateDetection = ActiveMQDefaultConfiguration.isDefaultBridgeDuplicateDetection();
    private int confirmationWindowSize = ActiveMQDefaultConfiguration.getDefaultBridgeConfirmationWindowSize();
    private int producerWindowSize = ActiveMQDefaultConfiguration.getDefaultBridgeProducerWindowSize();
    private long clientFailureCheckPeriod = ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD;
    private String user = ActiveMQDefaultConfiguration.getDefaultClusterUser();
    private String password = ActiveMQDefaultConfiguration.getDefaultClusterPassword();
    private long connectionTTL = ActiveMQClient.DEFAULT_CONNECTION_TTL;
    private long maxRetryInterval = ActiveMQClient.DEFAULT_MAX_RETRY_INTERVAL;
    private int minLargeMessageSize = 102400;
    private long callTimeout = 30000L;
    private ComponentConfigurationRoutingType routingType = ComponentConfigurationRoutingType.valueOf((String)ActiveMQDefaultConfiguration.getDefaultBridgeRoutingType());
    private int concurrency = ActiveMQDefaultConfiguration.getDefaultBridgeConcurrency();
    private String parentName = null;
    private boolean configurationManaged = true;

    public BridgeConfiguration() {
    }

    public BridgeConfiguration(BridgeConfiguration other) {
        this.name = other.name;
        this.parentName = other.parentName;
        this.queueName = other.queueName;
        this.forwardingAddress = other.forwardingAddress;
        this.filterString = other.filterString;
        this.staticConnectors = other.staticConnectors;
        this.discoveryGroupName = other.discoveryGroupName;
        this.ha = other.ha;
        this.transformerConfiguration = other.transformerConfiguration;
        this.retryInterval = other.retryInterval;
        this.retryIntervalMultiplier = other.retryIntervalMultiplier;
        this.initialConnectAttempts = other.initialConnectAttempts;
        this.reconnectAttempts = other.reconnectAttempts;
        this.reconnectAttemptsOnSameNode = other.reconnectAttemptsOnSameNode;
        this.useDuplicateDetection = other.useDuplicateDetection;
        this.confirmationWindowSize = other.confirmationWindowSize;
        this.producerWindowSize = other.producerWindowSize;
        this.clientFailureCheckPeriod = other.clientFailureCheckPeriod;
        this.user = other.user;
        this.password = other.password;
        this.connectionTTL = other.connectionTTL;
        this.maxRetryInterval = other.maxRetryInterval;
        this.minLargeMessageSize = other.minLargeMessageSize;
        this.callTimeout = other.callTimeout;
        this.routingType = other.routingType;
        this.concurrency = other.concurrency;
        this.configurationManaged = other.configurationManaged;
    }

    public BridgeConfiguration(String name) {
        this.setName(name);
    }

    public BridgeConfiguration set(String key, String value) {
        if (key != null) {
            if (key.equals(NAME)) {
                this.setName(value);
            } else if (key.equals(QUEUE_NAME)) {
                this.setQueueName(value);
            } else if (key.equals(FORWARDING_ADDRESS)) {
                this.setForwardingAddress(value);
            } else if (key.equals(FILTER_STRING)) {
                this.setFilterString(value);
            } else if (key.equals(STATIC_CONNECTORS)) {
                ArrayList<String> stringList = new ArrayList<String>();
                JsonArray staticConnectors = JsonLoader.readArray((Reader)new StringReader(value));
                for (int i = 0; i < staticConnectors.size(); ++i) {
                    stringList.add(staticConnectors.getString(i));
                }
                this.setStaticConnectors(stringList);
            } else if (key.equals(DISCOVERY_GROUP_NAME)) {
                this.setDiscoveryGroupName(value);
            } else if (key.equals(HA)) {
                this.setHA(Boolean.parseBoolean(value));
            } else if (key.equals(TRANSFORMER_CONFIGURATION)) {
                TransformerConfiguration transformerConfiguration = TransformerConfiguration.fromJSON((String)value);
                if (transformerConfiguration != null) {
                    this.setTransformerConfiguration(transformerConfiguration);
                }
            } else if (key.equals(RETRY_INTERVAL)) {
                this.setRetryInterval(Long.parseLong(value));
            } else if (key.equals(RETRY_INTERVAL_MULTIPLIER)) {
                this.setRetryIntervalMultiplier(Double.parseDouble(value));
            } else if (key.equals(INITIAL_CONNECT_ATTEMPTS)) {
                this.setInitialConnectAttempts(Integer.parseInt(value));
            } else if (key.equals(RECONNECT_ATTEMPTS)) {
                this.setReconnectAttempts(Integer.parseInt(value));
            } else if (key.equals(RECONNECT_ATTEMPTS_ON_SAME_NODE)) {
                this.setReconnectAttemptsOnSameNode(Integer.parseInt(value));
            } else if (key.equals(USE_DUPLICATE_DETECTION)) {
                this.setUseDuplicateDetection(Boolean.parseBoolean(value));
            } else if (key.equals(CONFIRMATION_WINDOW_SIZE)) {
                this.setConfirmationWindowSize(Integer.parseInt(value));
            } else if (key.equals(PRODUCER_WINDOW_SIZE)) {
                this.setProducerWindowSize(Integer.parseInt(value));
            } else if (key.equals(CLIENT_FAILURE_CHECK_PERIOD)) {
                this.setClientFailureCheckPeriod(Long.parseLong(value));
            } else if (key.equals(USER)) {
                this.setUser(value);
            } else if (key.equals(PASSWORD)) {
                this.setPassword(value);
            } else if (key.equals(CONNECTION_TTL)) {
                this.setConnectionTTL(Long.parseLong(value));
            } else if (key.equals(MAX_RETRY_INTERVAL)) {
                this.setMaxRetryInterval(Long.parseLong(value));
            } else if (key.equals(MIN_LARGE_MESSAGE_SIZE)) {
                this.setMinLargeMessageSize(Integer.parseInt(value));
            } else if (key.equals(CALL_TIMEOUT)) {
                this.setCallTimeout(Long.parseLong(value));
            } else if (key.equals(ROUTING_TYPE)) {
                this.setRoutingType(ComponentConfigurationRoutingType.valueOf((String)value));
            } else if (key.equals(CONCURRENCY)) {
                this.setConcurrency(Integer.parseInt(value));
            }
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public BridgeConfiguration setName(String name) {
        this.name = name;
        if (this.parentName == null) {
            this.parentName = name;
        }
        return this;
    }

    public String getParentName() {
        return this.parentName;
    }

    public BridgeConfiguration setParentName(String parentName) {
        this.parentName = parentName;
        return this;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public BridgeConfiguration setQueueName(String queueName) {
        this.queueName = queueName;
        return this;
    }

    public long getConnectionTTL() {
        return this.connectionTTL;
    }

    public BridgeConfiguration setConnectionTTL(long connectionTTL) {
        this.connectionTTL = connectionTTL;
        return this;
    }

    public long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public BridgeConfiguration setMaxRetryInterval(long maxRetryInterval) {
        this.maxRetryInterval = maxRetryInterval;
        return this;
    }

    public String getForwardingAddress() {
        return this.forwardingAddress;
    }

    public BridgeConfiguration setForwardingAddress(String forwardingAddress) {
        this.forwardingAddress = forwardingAddress;
        return this;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public BridgeConfiguration setFilterString(String filterString) {
        this.filterString = filterString;
        return this;
    }

    public TransformerConfiguration getTransformerConfiguration() {
        return this.transformerConfiguration;
    }

    public BridgeConfiguration setTransformerConfiguration(TransformerConfiguration transformerConfiguration) {
        this.transformerConfiguration = transformerConfiguration;
        return this;
    }

    public List<String> getStaticConnectors() {
        return this.staticConnectors;
    }

    public BridgeConfiguration setStaticConnectors(List<String> staticConnectors) {
        this.staticConnectors = staticConnectors;
        return this;
    }

    public String getDiscoveryGroupName() {
        return this.discoveryGroupName;
    }

    public BridgeConfiguration setDiscoveryGroupName(String discoveryGroupName) {
        this.discoveryGroupName = discoveryGroupName;
        return this;
    }

    public boolean isHA() {
        return this.ha;
    }

    public BridgeConfiguration setHA(boolean ha) {
        this.ha = ha;
        return this;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public BridgeConfiguration setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
        return this;
    }

    public double getRetryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    public BridgeConfiguration setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        return this;
    }

    public int getInitialConnectAttempts() {
        return this.initialConnectAttempts;
    }

    public BridgeConfiguration setInitialConnectAttempts(int initialConnectAttempts) {
        this.initialConnectAttempts = initialConnectAttempts;
        return this;
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public BridgeConfiguration setReconnectAttempts(int reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
        return this;
    }

    public boolean isUseDuplicateDetection() {
        return this.useDuplicateDetection;
    }

    public BridgeConfiguration setUseDuplicateDetection(boolean useDuplicateDetection) {
        this.useDuplicateDetection = useDuplicateDetection;
        return this;
    }

    public int getConfirmationWindowSize() {
        return this.confirmationWindowSize;
    }

    public BridgeConfiguration setConfirmationWindowSize(int confirmationWindowSize) {
        this.confirmationWindowSize = confirmationWindowSize;
        return this;
    }

    public int getProducerWindowSize() {
        return this.producerWindowSize;
    }

    public BridgeConfiguration setProducerWindowSize(int producerWindowSize) {
        this.producerWindowSize = producerWindowSize;
        return this;
    }

    public long getClientFailureCheckPeriod() {
        return this.clientFailureCheckPeriod;
    }

    public BridgeConfiguration setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
        return this;
    }

    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    public BridgeConfiguration setMinLargeMessageSize(int minLargeMessageSize) {
        this.minLargeMessageSize = minLargeMessageSize;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public BridgeConfiguration setUser(String user) {
        this.user = user;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public BridgeConfiguration setPassword(String password) {
        this.password = password;
        return this;
    }

    public long getCallTimeout() {
        return this.callTimeout;
    }

    public int getReconnectAttemptsOnSameNode() {
        return this.reconnectAttemptsOnSameNode;
    }

    public BridgeConfiguration setReconnectAttemptsOnSameNode(int reconnectAttemptsOnSameNode) {
        this.reconnectAttemptsOnSameNode = reconnectAttemptsOnSameNode;
        return this;
    }

    public boolean isConfigurationManaged() {
        return this.configurationManaged;
    }

    public BridgeConfiguration setConfigurationManaged(boolean configurationManaged) {
        this.configurationManaged = configurationManaged;
        return this;
    }

    public ComponentConfigurationRoutingType getRoutingType() {
        return this.routingType;
    }

    public BridgeConfiguration setRoutingType(ComponentConfigurationRoutingType routingType) {
        this.routingType = routingType;
        return this;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public BridgeConfiguration setConcurrency(int concurrency) {
        this.concurrency = concurrency;
        return this;
    }

    public BridgeConfiguration setCallTimeout(long callTimeout) {
        this.callTimeout = callTimeout;
        return this;
    }

    public String toJSON() {
        TransformerConfiguration tc;
        List<String> staticConnectors;
        JsonObjectBuilder builder = JsonLoader.createObjectBuilder();
        if (this.getName() != null) {
            builder.add(NAME, this.getName());
        }
        if (this.getQueueName() != null) {
            builder.add(QUEUE_NAME, this.getQueueName());
        }
        if (this.getForwardingAddress() != null) {
            builder.add(FORWARDING_ADDRESS, this.getForwardingAddress());
        }
        if (this.getFilterString() != null) {
            builder.add(FILTER_STRING, this.getFilterString());
        }
        if (this.getDiscoveryGroupName() != null) {
            builder.add(DISCOVERY_GROUP_NAME, this.getDiscoveryGroupName());
        }
        BridgeConfiguration.addNullable(builder, USER, this.getUser());
        BridgeConfiguration.addNullable(builder, PASSWORD, this.getPassword());
        builder.add(HA, this.isHA());
        builder.add(RETRY_INTERVAL, this.getRetryInterval());
        builder.add(RETRY_INTERVAL_MULTIPLIER, this.getRetryIntervalMultiplier());
        builder.add(INITIAL_CONNECT_ATTEMPTS, this.getInitialConnectAttempts());
        builder.add(RECONNECT_ATTEMPTS, this.getReconnectAttempts());
        builder.add(RECONNECT_ATTEMPTS_ON_SAME_NODE, this.getReconnectAttemptsOnSameNode());
        builder.add(USE_DUPLICATE_DETECTION, this.isUseDuplicateDetection());
        builder.add(CONFIRMATION_WINDOW_SIZE, this.getConfirmationWindowSize());
        builder.add(PRODUCER_WINDOW_SIZE, this.getProducerWindowSize());
        builder.add(CLIENT_FAILURE_CHECK_PERIOD, this.getClientFailureCheckPeriod());
        builder.add(CONNECTION_TTL, this.getConnectionTTL());
        builder.add(MAX_RETRY_INTERVAL, this.getMaxRetryInterval());
        builder.add(MIN_LARGE_MESSAGE_SIZE, this.getMinLargeMessageSize());
        builder.add(CALL_TIMEOUT, this.getCallTimeout());
        builder.add(CONCURRENCY, this.getConcurrency());
        builder.add(CONFIGURATION_MANAGED, this.isConfigurationManaged());
        if (this.getRoutingType() != null) {
            builder.add(ROUTING_TYPE, this.getRoutingType().name());
        }
        if ((staticConnectors = this.getStaticConnectors()) != null) {
            JsonArrayBuilder arrayBuilder = JsonLoader.createArrayBuilder();
            staticConnectors.forEach(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
            builder.add(STATIC_CONNECTORS, arrayBuilder);
        }
        if ((tc = this.getTransformerConfiguration()) != null) {
            JsonObjectBuilder tcBuilder = JsonLoader.createObjectBuilder().add("class-name", tc.getClassName());
            if (tc.getProperties() != null && tc.getProperties().size() > 0) {
                JsonObjectBuilder propBuilder = JsonLoader.createObjectBuilder();
                tc.getProperties().forEach((arg_0, arg_1) -> ((JsonObjectBuilder)propBuilder).add(arg_0, arg_1));
                tcBuilder.add("properties", propBuilder);
            }
            builder.add(TRANSFORMER_CONFIGURATION, tcBuilder);
        }
        return builder.build().toString();
    }

    private static void addNullable(JsonObjectBuilder builder, String key, String value) {
        if (value == null) {
            builder.addNull(key);
        } else {
            builder.add(key, value);
        }
    }

    public static BridgeConfiguration fromJSON(String jsonString) {
        JsonObject json = JsonLoader.readObject((Reader)new StringReader(jsonString));
        if (!json.containsKey((Object)NAME)) {
            return null;
        }
        BridgeConfiguration result = new BridgeConfiguration(json.getString(NAME));
        for (Map.Entry entry : json.entrySet()) {
            if (((JsonValue)entry.getValue()).getValueType() == JsonValue.ValueType.STRING) {
                result.set((String)entry.getKey(), ((JsonString)entry.getValue()).getString());
                continue;
            }
            if (((JsonValue)entry.getValue()).getValueType() == JsonValue.ValueType.NULL) {
                result.set((String)entry.getKey(), null);
                continue;
            }
            result.set((String)entry.getKey(), ((JsonValue)entry.getValue()).toString());
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.callTimeout ^ this.callTimeout >>> 32);
        result = 31 * result + (int)(this.clientFailureCheckPeriod ^ this.clientFailureCheckPeriod >>> 32);
        result = 31 * result + this.confirmationWindowSize;
        result = 31 * result + this.producerWindowSize;
        result = 31 * result + (int)(this.connectionTTL ^ this.connectionTTL >>> 32);
        result = 31 * result + (this.discoveryGroupName == null ? 0 : this.discoveryGroupName.hashCode());
        result = 31 * result + (this.filterString == null ? 0 : this.filterString.hashCode());
        result = 31 * result + (this.forwardingAddress == null ? 0 : this.forwardingAddress.hashCode());
        result = 31 * result + (this.ha ? 1231 : 1237);
        result = 31 * result + (int)(this.maxRetryInterval ^ this.maxRetryInterval >>> 32);
        result = 31 * result + this.minLargeMessageSize;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.queueName == null ? 0 : this.queueName.hashCode());
        result = 31 * result + this.initialConnectAttempts;
        result = 31 * result + this.reconnectAttempts;
        result = 31 * result + (int)(this.retryInterval ^ this.retryInterval >>> 32);
        long temp = Double.doubleToLongBits(this.retryIntervalMultiplier);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.staticConnectors == null ? 0 : this.staticConnectors.hashCode());
        result = 31 * result + (this.transformerConfiguration == null ? 0 : this.transformerConfiguration.hashCode());
        result = 31 * result + (this.useDuplicateDetection ? 1231 : 1237);
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        result = 31 * result + this.concurrency;
        result = 31 * result + (this.configurationManaged ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BridgeConfiguration other = (BridgeConfiguration)obj;
        if (this.callTimeout != other.callTimeout) {
            return false;
        }
        if (this.clientFailureCheckPeriod != other.clientFailureCheckPeriod) {
            return false;
        }
        if (this.confirmationWindowSize != other.confirmationWindowSize) {
            return false;
        }
        if (this.producerWindowSize != other.producerWindowSize) {
            return false;
        }
        if (this.connectionTTL != other.connectionTTL) {
            return false;
        }
        if (this.discoveryGroupName == null ? other.discoveryGroupName != null : !this.discoveryGroupName.equals(other.discoveryGroupName)) {
            return false;
        }
        if (this.filterString == null ? other.filterString != null : !this.filterString.equals(other.filterString)) {
            return false;
        }
        if (this.forwardingAddress == null ? other.forwardingAddress != null : !this.forwardingAddress.equals(other.forwardingAddress)) {
            return false;
        }
        if (this.ha != other.ha) {
            return false;
        }
        if (this.maxRetryInterval != other.maxRetryInterval) {
            return false;
        }
        if (this.minLargeMessageSize != other.minLargeMessageSize) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.parentName.equals(other.parentName)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.queueName == null ? other.queueName != null : !this.queueName.equals(other.queueName)) {
            return false;
        }
        if (this.initialConnectAttempts != other.initialConnectAttempts) {
            return false;
        }
        if (this.reconnectAttempts != other.reconnectAttempts) {
            return false;
        }
        if (this.retryInterval != other.retryInterval) {
            return false;
        }
        if (Double.doubleToLongBits(this.retryIntervalMultiplier) != Double.doubleToLongBits(other.retryIntervalMultiplier)) {
            return false;
        }
        if (this.staticConnectors == null ? other.staticConnectors != null : !this.staticConnectors.equals(other.staticConnectors)) {
            return false;
        }
        if (this.transformerConfiguration == null ? other.transformerConfiguration != null : !this.transformerConfiguration.equals((Object)other.transformerConfiguration)) {
            return false;
        }
        if (this.useDuplicateDetection != other.useDuplicateDetection) {
            return false;
        }
        if (this.user == null ? other.user != null : !this.user.equals(other.user)) {
            return false;
        }
        if (this.concurrency != other.concurrency) {
            return false;
        }
        return this.configurationManaged == other.configurationManaged;
    }

    public int getEncodeSize() {
        int transformerSize = 0;
        if (this.transformerConfiguration != null) {
            transformerSize += BufferHelper.sizeOfNullableString((String)this.transformerConfiguration.getClassName());
            transformerSize += 6;
            Map properties = this.transformerConfiguration.getProperties();
            for (Map.Entry entry : properties.entrySet()) {
                transformerSize += BufferHelper.sizeOfNullableString((String)((String)entry.getKey()));
                transformerSize += BufferHelper.sizeOfNullableString((String)((String)entry.getValue()));
            }
        }
        int staticConnectorSize = 0;
        if (this.staticConnectors != null) {
            staticConnectorSize += BufferHelper.sizeOfNullableInteger((Integer)this.staticConnectors.size());
            for (String string : this.staticConnectors) {
                staticConnectorSize += BufferHelper.sizeOfNullableString((String)string);
            }
        }
        int size = BufferHelper.sizeOfNullableString((String)this.name) + BufferHelper.sizeOfNullableString((String)this.parentName) + BufferHelper.sizeOfNullableString((String)this.queueName) + BufferHelper.sizeOfNullableString((String)this.forwardingAddress) + BufferHelper.sizeOfNullableString((String)this.filterString) + BufferHelper.sizeOfNullableString((String)this.discoveryGroupName) + BufferHelper.sizeOfNullableBoolean((Boolean)this.ha) + BufferHelper.sizeOfNullableLong((Long)this.retryInterval) + BufferHelper.sizeOfNullableDouble((Double)this.retryIntervalMultiplier) + BufferHelper.sizeOfNullableInteger((Integer)this.initialConnectAttempts) + BufferHelper.sizeOfNullableInteger((Integer)this.reconnectAttempts) + BufferHelper.sizeOfNullableInteger((Integer)this.reconnectAttemptsOnSameNode) + BufferHelper.sizeOfNullableBoolean((Boolean)this.useDuplicateDetection) + BufferHelper.sizeOfNullableInteger((Integer)this.confirmationWindowSize) + BufferHelper.sizeOfNullableInteger((Integer)this.producerWindowSize) + BufferHelper.sizeOfNullableLong((Long)this.clientFailureCheckPeriod) + BufferHelper.sizeOfNullableString((String)this.user) + BufferHelper.sizeOfNullableString((String)this.password) + BufferHelper.sizeOfNullableLong((Long)this.connectionTTL) + BufferHelper.sizeOfNullableLong((Long)this.maxRetryInterval) + BufferHelper.sizeOfNullableInteger((Integer)this.minLargeMessageSize) + BufferHelper.sizeOfNullableLong((Long)this.callTimeout) + BufferHelper.sizeOfNullableInteger((Integer)this.concurrency) + BufferHelper.sizeOfNullableBoolean((Boolean)this.configurationManaged) + 1 + transformerSize + staticConnectorSize;
        return size;
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeNullableString(this.name);
        buffer.writeNullableString(this.parentName);
        buffer.writeNullableString(this.queueName);
        buffer.writeNullableString(this.forwardingAddress);
        buffer.writeNullableString(this.filterString);
        buffer.writeNullableString(this.discoveryGroupName);
        buffer.writeNullableBoolean(Boolean.valueOf(this.ha));
        buffer.writeNullableLong(Long.valueOf(this.retryInterval));
        BufferHelper.writeNullableDouble((ActiveMQBuffer)buffer, (Double)this.retryIntervalMultiplier);
        buffer.writeNullableInt(Integer.valueOf(this.initialConnectAttempts));
        buffer.writeNullableInt(Integer.valueOf(this.reconnectAttempts));
        buffer.writeNullableInt(Integer.valueOf(this.reconnectAttemptsOnSameNode));
        buffer.writeNullableBoolean(Boolean.valueOf(this.useDuplicateDetection));
        buffer.writeNullableInt(Integer.valueOf(this.confirmationWindowSize));
        buffer.writeNullableInt(Integer.valueOf(this.producerWindowSize));
        buffer.writeNullableLong(Long.valueOf(this.clientFailureCheckPeriod));
        buffer.writeNullableString(this.user);
        buffer.writeNullableString(this.password);
        buffer.writeNullableLong(Long.valueOf(this.connectionTTL));
        buffer.writeNullableLong(Long.valueOf(this.maxRetryInterval));
        buffer.writeNullableInt(Integer.valueOf(this.minLargeMessageSize));
        buffer.writeNullableLong(Long.valueOf(this.callTimeout));
        buffer.writeNullableInt(Integer.valueOf(this.concurrency));
        buffer.writeNullableBoolean(Boolean.valueOf(this.configurationManaged));
        buffer.writeByte(this.routingType != null ? this.routingType.getType() : ComponentConfigurationRoutingType.valueOf((String)ActiveMQDefaultConfiguration.getDefaultDivertRoutingType()).getType());
        if (this.transformerConfiguration != null) {
            buffer.writeString(this.transformerConfiguration.getClassName());
            Map properties = this.transformerConfiguration.getProperties();
            buffer.writeInt(properties.size());
            for (Map.Entry entry : properties.entrySet()) {
                buffer.writeNullableString((String)entry.getKey());
                buffer.writeNullableString((String)entry.getValue());
            }
        } else {
            buffer.writeNullableString(null);
        }
        if (this.staticConnectors != null) {
            buffer.writeInt(this.staticConnectors.size());
            for (String connector : this.staticConnectors) {
                buffer.writeNullableString(connector);
            }
        } else {
            buffer.writeInt(0);
        }
    }

    public void decode(ActiveMQBuffer buffer) {
        int numStaticConnectors;
        int i;
        this.name = buffer.readNullableString();
        this.parentName = buffer.readNullableString();
        this.queueName = buffer.readNullableString();
        this.forwardingAddress = buffer.readNullableString();
        this.filterString = buffer.readNullableString();
        this.discoveryGroupName = buffer.readNullableString();
        this.ha = buffer.readNullableBoolean();
        this.retryInterval = buffer.readNullableLong();
        this.retryIntervalMultiplier = BufferHelper.readNullableDouble((ActiveMQBuffer)buffer);
        this.initialConnectAttempts = buffer.readNullableInt();
        this.reconnectAttempts = buffer.readNullableInt();
        this.reconnectAttemptsOnSameNode = buffer.readNullableInt();
        this.useDuplicateDetection = buffer.readNullableBoolean();
        this.confirmationWindowSize = buffer.readNullableInt();
        this.producerWindowSize = buffer.readNullableInt();
        this.clientFailureCheckPeriod = buffer.readNullableLong();
        this.user = buffer.readNullableString();
        this.password = buffer.readNullableString();
        this.connectionTTL = buffer.readNullableLong();
        this.maxRetryInterval = buffer.readNullableLong();
        this.minLargeMessageSize = buffer.readNullableInt();
        this.callTimeout = buffer.readNullableLong();
        this.concurrency = buffer.readNullableInt();
        this.configurationManaged = buffer.readNullableBoolean();
        this.routingType = ComponentConfigurationRoutingType.getType((byte)buffer.readByte());
        String transformerClassName = buffer.readNullableString();
        if (transformerClassName != null) {
            this.transformerConfiguration = new TransformerConfiguration(transformerClassName);
            int propsSize = buffer.readInt();
            for (i = 0; i < propsSize; ++i) {
                this.transformerConfiguration.getProperties().put(buffer.readNullableString(), buffer.readNullableString());
            }
        }
        if ((numStaticConnectors = buffer.readInt()) > 0) {
            this.staticConnectors = new ArrayList<String>();
            for (i = 0; i < numStaticConnectors; ++i) {
                this.staticConnectors.add(buffer.readNullableString());
            }
        }
    }
}

