/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kahadb.journal;

import java.io.IOException;
import java.util.zip.Adler32;
import org.apache.kahadb.journal.DataFile;
import org.apache.kahadb.journal.DataFileAppender;
import org.apache.kahadb.journal.Journal;
import org.apache.kahadb.util.DataByteArrayOutputStream;

class CallerBufferingDataFileAppender
extends DataFileAppender {
    final DataByteArrayOutputStream[] cachedBuffers;
    volatile byte flip;

    protected DataFileAppender.WriteBatch newWriteBatch(Journal.WriteCommand write, DataFile file) throws IOException {
        return new WriteBatch(file, file.getLength(), write);
    }

    private void initBuffer(DataByteArrayOutputStream buff) throws IOException {
        buff.reset();
        buff.write(Journal.BATCH_CONTROL_RECORD_HEADER);
        buff.writeInt(0);
        buff.writeLong(0L);
    }

    public CallerBufferingDataFileAppender(Journal dataManager) {
        super(dataManager);
        this.cachedBuffers = new DataByteArrayOutputStream[]{new DataByteArrayOutputStream(this.maxWriteBatchSize), new DataByteArrayOutputStream(this.maxWriteBatchSize)};
        this.flip = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processQueue() {
        dataFile = null;
        file = null;
        wb = null;
        try {
            block39: {
                block36: {
                    try {
                        while (true) {
                            block35: {
                                o = null;
                                var5_7 = this.enqueueMutex;
                                synchronized (var5_7) {
                                    while (true) {
                                        if (this.nextWriteBatch != null) {
                                            o = this.nextWriteBatch;
                                            this.nextWriteBatch = null;
                                            this.enqueueMutex.notifyAll();
                                            // MONITOREXIT @DISABLED, blocks:[16, 0, 1, 34, 6, 15] lbl15 : MonitorExitStatement: MONITOREXIT : var5_7
                                            wb = (WriteBatch)o;
                                            if (dataFile != wb.dataFile) {
                                                break;
                                            }
                                            break block35;
                                        }
                                        if (this.shutdown) {
                                            // MONITOREXIT @DISABLED, blocks:[16, 0, 33, 1, 6, 15] lbl21 : MonitorExitStatement: MONITOREXIT : var5_7
                                            var12_14 = null;
                                            break block36;
                                        }
                                        this.enqueueMutex.wait();
                                    }
                                }
                                if (file != null) {
                                    file.setLength(dataFile.getLength());
                                    dataFile.closeRandomAccessFile(file);
                                }
                                if ((file = (dataFile = wb.dataFile).openRandomAccessFile()).length() < (long)this.journal.preferedFileLength) {
                                    file.setLength(this.journal.preferedFileLength);
                                }
                            }
                            buff = wb.buff;
                            forceToDisk = WriteBatch.access$200(wb);
                            sequence = buff.toByteSequence();
                            buff.reset();
                            buff.skip(5 + Journal.BATCH_CONTROL_RECORD_MAGIC.length);
                            buff.writeInt(sequence.getLength() - Journal.BATCH_CONTROL_RECORD_SIZE);
                            if (this.journal.isChecksum()) {
                                checksum = new Adler32();
                                checksum.update(sequence.getData(), sequence.getOffset() + Journal.BATCH_CONTROL_RECORD_SIZE, sequence.getLength() - Journal.BATCH_CONTROL_RECORD_SIZE);
                                buff.writeLong(checksum.getValue());
                            }
                            file.seek(wb.offset);
                            if (CallerBufferingDataFileAppender.maxStat > 0) {
                                if (this.statIdx < CallerBufferingDataFileAppender.maxStat) {
                                    this.stats[this.statIdx++] = sequence.getLength();
                                } else {
                                    all = 0L;
                                    while (this.statIdx > 0) {
                                        all += (long)this.stats[--this.statIdx];
                                    }
                                    System.err.println("Ave writeSize: " + all / (long)CallerBufferingDataFileAppender.maxStat);
                                }
                            }
                            file.write(sequence.getData(), sequence.getOffset(), sequence.getLength());
                            replicationTarget = this.journal.getReplicationTarget();
                            if (replicationTarget != null) {
                                replicationTarget.replicate(((Journal.WriteCommand)wb.writes.getHead()).location, sequence, forceToDisk);
                            }
                            if (forceToDisk) {
                                file.getFD().sync();
                            }
                            lastWrite = (Journal.WriteCommand)wb.writes.getTail();
                            this.journal.setLastAppendLocation(lastWrite.location);
                            this.signalDone(wb);
                        }
                    }
                    catch (IOException e) {
                        var5_8 = this.enqueueMutex;
                        synchronized (var5_8) {
                            this.firstAsyncException = e;
                            if (wb != null) {
                                wb.exception.set(e);
                                wb.latch.countDown();
                            }
                            if (this.nextWriteBatch != null) {
                                this.nextWriteBatch.exception.set(e);
                                this.nextWriteBatch.latch.countDown();
                            }
                        }
                        var12_15 = null;
                        try {
                            if (file != null) {
                                dataFile.closeRandomAccessFile(file);
                            }
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                        this.shutdownDone.countDown();
                        this.running = false;
                        return;
                    }
                    catch (InterruptedException e) {
                        block38: {
                            var12_16 = null;
                            ** try [egrp 5[TRYBLOCK] [13 : 582->594)] { 
lbl89:
                            // 1 sources

                            if (file != null) {
                                dataFile.closeRandomAccessFile(file);
                            }
                            break block38;
lbl92:
                            // 1 sources

                            catch (Throwable ignore) {
                                // empty catch block
                            }
                        }
                        this.shutdownDone.countDown();
                        this.running = false;
                        return;
                    }
                }
                ** try [egrp 5[TRYBLOCK] [13 : 582->594)] { 
lbl100:
                // 1 sources

                if (file != null) {
                    dataFile.closeRandomAccessFile(file);
                }
                break block39;
lbl103:
                // 1 sources

                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            this.shutdownDone.countDown();
            this.running = false;
            return;
        }
        catch (Throwable var11_22) {
            block40: {
                var12_17 = null;
                ** try [egrp 5[TRYBLOCK] [13 : 582->594)] { 
lbl113:
                // 1 sources

                if (file != null) {
                    dataFile.closeRandomAccessFile(file);
                }
                break block40;
lbl116:
                // 1 sources

                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            this.shutdownDone.countDown();
            this.running = false;
            throw var11_22;
        }
    }

    private boolean appendToBuffer(Journal.WriteCommand write, DataByteArrayOutputStream buff) throws IOException {
        buff.writeInt(write.location.getSize());
        buff.writeByte(write.location.getType());
        buff.write(write.data.getData(), write.data.getOffset(), write.data.getLength());
        return write.sync | (this.syncOnComplete && write.onComplete != null);
    }

    public class WriteBatch
    extends DataFileAppender.WriteBatch {
        DataByteArrayOutputStream buff;
        private boolean forceToDisk;

        public WriteBatch(DataFile dataFile, int offset, Journal.WriteCommand write) throws IOException {
            super(CallerBufferingDataFileAppender.this, dataFile, offset);
            CallerBufferingDataFileAppender.this.flip = (byte)(CallerBufferingDataFileAppender.this.flip ^ 1);
            this.buff = CallerBufferingDataFileAppender.this.cachedBuffers[CallerBufferingDataFileAppender.this.flip];
            CallerBufferingDataFileAppender.this.initBuffer(this.buff);
            this.append(write);
        }

        public void append(Journal.WriteCommand write) throws IOException {
            super.append(write);
            this.forceToDisk |= CallerBufferingDataFileAppender.this.appendToBuffer(write, this.buff);
        }

        static /* synthetic */ boolean access$200(WriteBatch x0) {
            return x0.forceToDisk;
        }
    }
}

