/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.shaded.ning19.com.ning.http.client.oauth;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.apex.shaded.ning19.com.ning.http.client.oauth.ConsumerKey;
import org.apache.apex.shaded.ning19.com.ning.http.client.oauth.RequestToken;
import org.apache.apex.shaded.ning19.com.ning.http.util.StringUtils;
import org.apache.apex.shaded.ning19.com.ning.http.util.UTF8UrlEncoder;

public class ThreadSafeHMAC {
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private final Mac mac;

    public ThreadSafeHMAC(ConsumerKey consumerAuth, RequestToken userAuth) {
        StringBuilder sb = StringUtils.stringBuilder();
        UTF8UrlEncoder.encodeAndAppendQueryElement(sb, consumerAuth.getSecret());
        sb.append('&');
        UTF8UrlEncoder.encodeAndAppendQueryElement(sb, userAuth.getSecret());
        byte[] keyBytes = StringUtils.charSequence2Bytes(sb, StandardCharsets.UTF_8);
        SecretKeySpec signingKey = new SecretKeySpec(keyBytes, HMAC_SHA1_ALGORITHM);
        try {
            this.mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            this.mac.init(signingKey);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public synchronized byte[] digest(ByteBuffer message) {
        this.mac.reset();
        this.mac.update(message);
        return this.mac.doFinal();
    }
}

