/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.request.body;

import java.io.IOException;
import org.apache.apex.shaded.ning19.com.ning.http.client.AsyncHttpClientConfig;
import org.apache.apex.shaded.ning19.com.ning.http.client.Body;
import org.apache.apex.shaded.ning19.com.ning.http.client.BodyGenerator;
import org.apache.apex.shaded.ning19.com.ning.http.client.RandomAccessBody;
import org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.channel.ChannelManager;
import org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.future.NettyResponseFuture;
import org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.request.ProgressListener;
import org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.request.body.BodyChunkedInput;
import org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.request.body.BodyFileRegion;
import org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.request.body.FeedableBodyGenerator;
import org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.request.body.NettyBody;
import org.apache.apex.shaded.ning19.com.ning.http.util.MiscUtils;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.Channel;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.ChannelFuture;
import org.apache.apex.shaded.ning19.org.jboss.netty.handler.stream.ChunkedWriteHandler;

public class NettyBodyBody
implements NettyBody {
    private final Body body;
    private final NettyAsyncHttpProviderConfig nettyConfig;

    public NettyBodyBody(Body body, NettyAsyncHttpProviderConfig nettyConfig) {
        this.body = body;
        this.nettyConfig = nettyConfig;
    }

    public Body getBody() {
        return this.body;
    }

    @Override
    public long getContentLength() {
        return this.body.getContentLength();
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public void write(final Channel channel, NettyResponseFuture<?> future, AsyncHttpClientConfig config) throws IOException {
        Object msg;
        if (this.body instanceof RandomAccessBody && !ChannelManager.isSslHandlerConfigured(channel.getPipeline()) && !this.nettyConfig.isDisableZeroCopy()) {
            msg = new BodyFileRegion((RandomAccessBody)this.body);
        } else {
            msg = new BodyChunkedInput(this.body);
            BodyGenerator bg = future.getRequest().getBodyGenerator();
            if (bg instanceof FeedableBodyGenerator) {
                FeedableBodyGenerator feedableBodyGenerator = (FeedableBodyGenerator)bg;
                feedableBodyGenerator.writeChunkBoundaries();
                feedableBodyGenerator.setListener(new FeedableBodyGenerator.FeedListener(){

                    @Override
                    public void onContentAdded() {
                        channel.getPipeline().get(ChunkedWriteHandler.class).resumeTransfer();
                    }
                });
            }
        }
        channel.write(msg).addListener(new ProgressListener(config, future.getAsyncHandler(), future, false){

            @Override
            public void operationComplete(ChannelFuture cf) {
                MiscUtils.closeSilently(NettyBodyBody.this.body);
                super.operationComplete(cf);
            }
        });
    }
}

