/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.shaded.ning19.org.jboss.netty.handler.codec.protobuf;

import com.google.protobuf.CodedInputStream;
import org.apache.apex.shaded.ning19.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.Channel;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.apex.shaded.ning19.org.jboss.netty.handler.codec.frame.CorruptedFrameException;
import org.apache.apex.shaded.ning19.org.jboss.netty.handler.codec.frame.FrameDecoder;

public class ProtobufVarint32FrameDecoder
extends FrameDecoder {
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        buffer.markReaderIndex();
        byte[] buf = new byte[5];
        for (int i = 0; i < buf.length; ++i) {
            if (!buffer.readable()) {
                buffer.resetReaderIndex();
                return null;
            }
            buf[i] = buffer.readByte();
            if (buf[i] < 0) continue;
            int length = CodedInputStream.newInstance((byte[])buf, (int)0, (int)(i + 1)).readRawVarint32();
            if (length < 0) {
                throw new CorruptedFrameException("negative length: " + length);
            }
            if (buffer.readableBytes() < length) {
                buffer.resetReaderIndex();
                return null;
            }
            return buffer.readBytes(length);
        }
        throw new CorruptedFrameException("length wider than 32-bit");
    }
}

