/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.accumulo;

import com.datatorrent.api.Context;
import com.datatorrent.api.Operator;
import com.datatorrent.contrib.accumulo.AccumuloWindowStore;
import com.datatorrent.lib.db.AbstractAggregateTransactionableStoreOutputOperator;
import com.datatorrent.netlet.util.DTThrowable;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.data.Mutation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAccumuloOutputOperator<T>
extends AbstractAggregateTransactionableStoreOutputOperator<T, AccumuloWindowStore> {
    private static final transient Logger logger = LoggerFactory.getLogger(AbstractAccumuloOutputOperator.class);
    private final List<T> tuples = Lists.newArrayList();
    private transient Operator.ProcessingMode mode;

    public Operator.ProcessingMode getMode() {
        return this.mode;
    }

    public void setMode(Operator.ProcessingMode mode) {
        this.mode = mode;
    }

    public AbstractAccumuloOutputOperator() {
        this.store = new AccumuloWindowStore();
    }

    public void processTuple(T tuple) {
        this.tuples.add(tuple);
    }

    public void storeAggregate() {
        try {
            for (T tuple : this.tuples) {
                Mutation mutation = this.operationMutation(tuple);
                ((AccumuloWindowStore)this.store).getBatchwriter().addMutation(mutation);
            }
            ((AccumuloWindowStore)this.store).getBatchwriter().flush();
        }
        catch (MutationsRejectedException e) {
            logger.error("unable to write mutations", (Throwable)e);
            DTThrowable.rethrow((Exception)((Object)e));
        }
        this.tuples.clear();
    }

    public abstract Mutation operationMutation(T var1);

    public void setup(Context.OperatorContext context) {
        this.mode = (Operator.ProcessingMode)context.getValue(Context.OperatorContext.PROCESSING_MODE);
        if (this.mode == Operator.ProcessingMode.EXACTLY_ONCE) {
            throw new RuntimeException("This operator only supports atmost once and atleast once processing modes");
        }
        if (this.mode == Operator.ProcessingMode.AT_MOST_ONCE) {
            this.tuples.clear();
        }
        super.setup(context);
    }
}

