/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.accumulo;

import com.datatorrent.lib.db.Connectable;
import com.datatorrent.netlet.util.DTThrowable;
import java.io.IOException;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloStore
implements Connectable {
    private static final transient Logger logger = LoggerFactory.getLogger(AccumuloStore.class);
    private String zookeeperHost;
    private String instanceName;
    private String userName;
    private String password;
    protected String tableName;
    protected transient Connector connector;
    protected transient BatchWriter batchwriter;
    private long memoryLimit = 0x80000000L;
    private int numThreads = 1;
    private static final long DEFAULT_MEMORY = 0x80000000L;
    private static final int DEFAULT_THREADS = 1;

    public Connector getConnector() {
        return this.connector;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getZookeeperHost() {
        return this.zookeeperHost;
    }

    public void setZookeeperHost(String zookeeperHost) {
        this.zookeeperHost = zookeeperHost;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setMemoryLimit(long memoryLimit) {
        this.memoryLimit = memoryLimit;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public BatchWriter getBatchwriter() {
        return this.batchwriter;
    }

    public void connect() throws IOException {
        ZooKeeperInstance instance = null;
        instance = new ZooKeeperInstance(this.instanceName, this.zookeeperHost);
        try {
            PasswordToken t = new PasswordToken(this.password.getBytes());
            this.connector = instance.getConnector(this.userName, (AuthenticationToken)t);
        }
        catch (AccumuloException e) {
            logger.error("error connecting to accumulo", (Throwable)e);
            DTThrowable.rethrow((Exception)((Object)e));
        }
        catch (AccumuloSecurityException e) {
            logger.error("error connecting to accumulo", (Throwable)e);
            DTThrowable.rethrow((Exception)((Object)e));
        }
        BatchWriterConfig config = new BatchWriterConfig();
        config.setMaxMemory(this.memoryLimit);
        config.setMaxWriteThreads(this.numThreads);
        try {
            this.batchwriter = this.connector.createBatchWriter(this.tableName, config);
        }
        catch (TableNotFoundException e) {
            logger.error("table not found", (Throwable)e);
            DTThrowable.rethrow((Exception)((Object)e));
        }
    }

    public void disconnect() throws IOException {
        try {
            this.batchwriter.close();
        }
        catch (MutationsRejectedException e) {
            logger.error("mutation rejected during batchwriter close", (Throwable)e);
            DTThrowable.rethrow((Exception)((Object)e));
        }
    }

    public boolean isConnected() {
        return false;
    }
}

