/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.accumulo;

import com.datatorrent.contrib.accumulo.AccumuloStore;
import com.datatorrent.lib.db.TransactionableStore;
import com.datatorrent.netlet.util.DTThrowable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloWindowStore
extends AccumuloStore
implements TransactionableStore {
    private static final transient Logger logger = LoggerFactory.getLogger(AccumuloWindowStore.class);
    private static final String DEFAULT_ROW_NAME = "AccumuloOperator_row";
    private static final String DEFAULT_COLUMN_FAMILY_NAME = "AccumuloOutputOperator_cf";
    private static final String DEFAULT_LAST_WINDOW_PREFIX_COLUMN_NAME = "last_window";
    private transient String rowName = "AccumuloOperator_row";
    private transient String columnFamilyName = "AccumuloOutputOperator_cf";
    private transient byte[] rowBytes;
    private transient byte[] columnFamilyBytes;
    private transient String lastWindowColumnName = "last_window";
    private transient byte[] lastWindowColumnBytes;

    public AccumuloWindowStore() {
        this.constructKeys();
    }

    private void constructKeys() {
        this.rowBytes = this.rowName.getBytes();
        this.columnFamilyBytes = this.columnFamilyName.getBytes();
    }

    public String getRowName() {
        return this.rowName;
    }

    public void setRowName(String rowName) {
        this.rowName = rowName;
        this.constructKeys();
    }

    public String getColumnFamilyName() {
        return this.columnFamilyName;
    }

    public void setColumnFamilyName(String columnFamilyName) {
        this.columnFamilyName = columnFamilyName;
        this.constructKeys();
    }

    public void beginTransaction() {
    }

    public void commitTransaction() {
    }

    public void rollbackTransaction() {
    }

    public boolean isInTransaction() {
        return false;
    }

    public long getCommittedWindowId(String appId, int operatorId) {
        byte[] value = null;
        Authorizations auths = new Authorizations();
        Scanner scan = null;
        String columnKey = appId + "_" + operatorId + "_" + this.lastWindowColumnName;
        this.lastWindowColumnBytes = columnKey.getBytes();
        try {
            scan = this.connector.createScanner(this.tableName, auths);
        }
        catch (TableNotFoundException e) {
            logger.error("error getting committed window id", (Throwable)e);
            DTThrowable.rethrow((Exception)((Object)e));
        }
        scan.setRange(new Range(new Text(this.rowBytes)));
        scan.fetchColumn(new Text(this.columnFamilyBytes), new Text(this.lastWindowColumnBytes));
        for (Map.Entry entry : scan) {
            value = ((Value)entry.getValue()).get();
        }
        if (value != null) {
            long longval = AccumuloWindowStore.toLong(value);
            return longval;
        }
        return -1L;
    }

    public void storeCommittedWindowId(String appId, int operatorId, long windowId) {
        byte[] WindowIdBytes = AccumuloWindowStore.toBytes(windowId);
        String columnKey = appId + "_" + operatorId + "_" + this.lastWindowColumnName;
        this.lastWindowColumnBytes = columnKey.getBytes();
        Mutation mutation = new Mutation(this.rowBytes);
        mutation.put(this.columnFamilyBytes, this.lastWindowColumnBytes, WindowIdBytes);
        try {
            this.batchwriter.addMutation(mutation);
            this.batchwriter.flush();
        }
        catch (MutationsRejectedException e) {
            logger.error("error getting committed window id", (Throwable)e);
            DTThrowable.rethrow((Exception)((Object)e));
        }
    }

    public void removeCommittedWindowId(String appId, int operatorId) {
    }

    public static byte[] toBytes(long l) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8);
        DataOutputStream dos = new DataOutputStream(baos);
        byte[] result = null;
        try {
            dos.writeLong(l);
            result = baos.toByteArray();
            dos.close();
        }
        catch (IOException e) {
            logger.error("error converting to byte array");
            DTThrowable.rethrow((Exception)e);
        }
        return result;
    }

    public static long toLong(byte[] b) {
        ByteArrayInputStream baos = new ByteArrayInputStream(b);
        DataInputStream dos = new DataInputStream(baos);
        long result = 0L;
        try {
            result = dos.readLong();
            dos.close();
        }
        catch (IOException e) {
            logger.error("error converting to long");
            DTThrowable.rethrow((Exception)e);
        }
        return result;
    }
}

