/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.apachelog;

import com.datatorrent.lib.logs.InformationExtractor;
import com.maxmind.geoip.Location;
import com.maxmind.geoip.LookupService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoIPExtractor
implements InformationExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(GeoIPExtractor.class);
    private static final long serialVersionUID = 201404221817L;
    private transient LookupService reader;
    @NotNull
    private String databasePath;

    public String getDatabasePath() {
        return this.databasePath;
    }

    public void setDatabasePath(String databasePath) {
        this.databasePath = databasePath;
    }

    public void setup() {
        try {
            this.reader = new LookupService(this.databasePath, 3);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void teardown() {
        this.reader.close();
    }

    public Map<String, Object> extractInformation(Object value) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        try {
            Location location = this.reader.getLocation(value.toString());
            if (location != null) {
                m.put("ipCountry", location.countryCode);
                m.put("ipRegion", location.region);
                m.put("ipCity", location.city);
            }
        }
        catch (Exception ex) {
            LOG.error("Caught exception when looking up Geo IP for {}:", value, (Object)ex);
        }
        return m;
    }
}

