/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.apachelog;

import com.datatorrent.contrib.apachelog.GeoIPExtractor;
import com.datatorrent.lib.logs.InformationExtractor;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampExtractor
implements InformationExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(GeoIPExtractor.class);
    private static final long serialVersionUID = 201404221817L;
    @NotNull
    private String dateFormatString;
    private transient DateFormat dateFormat;

    public void setDateFormatString(String dateFormatString) {
        this.dateFormatString = dateFormatString;
    }

    public void setup() {
        this.dateFormat = new SimpleDateFormat(this.dateFormatString);
    }

    public void teardown() {
    }

    public Map<String, Object> extractInformation(Object value) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        try {
            Date date = this.dateFormat.parse((String)value);
            m.put("timestamp", date.getTime());
        }
        catch (ParseException ex) {
            LOG.error("Error parsing \"{}\" to timestamp using \"{}\":", new Object[]{value, this.dateFormatString, ex});
        }
        return m;
    }
}

