/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.avro;

import java.text.ParseException;
import java.util.List;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroRecordHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AvroRecordHelper.class);

    public static Object convertValueStringToAvroKeyType(Schema schema, String key, String value) throws ParseException {
        Schema.Type type = null;
        if (schema.getField(key) == null) {
            return value;
        }
        type = schema.getField(key).schema().getType();
        Object convertedValue = null;
        convertedValue = type == Schema.Type.UNION ? AvroRecordHelper.convertAndResolveUnionToPrimitive(schema, key, value) : AvroRecordHelper.convertValueToAvroPrimitive(type, key, value);
        return convertedValue;
    }

    private static Object convertValueToAvroPrimitive(Schema.Type type, String key, String value) throws ParseException {
        Object newValue = value;
        switch (type) {
            case BOOLEAN: {
                newValue = Boolean.parseBoolean(value);
                break;
            }
            case DOUBLE: {
                newValue = Double.parseDouble(value);
                break;
            }
            case FLOAT: {
                newValue = Float.valueOf(Float.parseFloat(value));
                break;
            }
            case INT: {
                newValue = Integer.parseInt(value);
                break;
            }
            case LONG: {
                newValue = Long.parseLong(value);
                break;
            }
            case BYTES: {
                newValue = value.getBytes();
                break;
            }
            case STRING: {
                newValue = value;
                break;
            }
            case NULL: {
                newValue = null;
                break;
            }
            default: {
                newValue = value;
            }
        }
        return newValue;
    }

    private static Object convertAndResolveUnionToPrimitive(Schema schema, String key, String value) throws ParseException {
        Schema unionSchema = schema.getField(key).schema();
        List types = unionSchema.getTypes();
        Object convertedValue = null;
        for (int i = 0; i < types.size(); ++i) {
            try {
                if (((Schema)types.get(i)).getType() == Schema.Type.NULL) {
                    if (value != null && !value.equals("null")) continue;
                    convertedValue = null;
                    break;
                }
                convertedValue = AvroRecordHelper.convertValueToAvroPrimitive(((Schema)types.get(i)).getType(), key, value);
                break;
            }
            catch (RuntimeException e) {
                LOG.error("Could not handle schema resolution", (Throwable)e);
            }
        }
        return convertedValue;
    }
}

