/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.cassandra;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datatorrent.api.Context;
import com.datatorrent.api.Operator;
import com.datatorrent.contrib.cassandra.CassandraTransactionalStore;
import com.datatorrent.lib.db.AbstractBatchTransactionableStoreOutputOperator;
import java.util.Collection;
import javax.annotation.Nonnull;

public abstract class AbstractCassandraTransactionableOutputOperator<T>
extends AbstractBatchTransactionableStoreOutputOperator<T, CassandraTransactionalStore>
implements Operator.ActivationListener<Context.OperatorContext> {
    private transient PreparedStatement updateCommand;

    public void activate(Context.OperatorContext context) {
        this.updateCommand = this.getUpdateCommand();
    }

    @Nonnull
    protected abstract PreparedStatement getUpdateCommand();

    protected abstract Statement setStatementParameters(PreparedStatement var1, T var2) throws DriverException;

    public void processBatch(Collection<T> tuples) {
        BatchStatement batchCommand = ((CassandraTransactionalStore)this.store).getBatchCommand();
        for (T tuple : tuples) {
            batchCommand.add(this.setStatementParameters(this.updateCommand, tuple));
        }
    }

    public void deactivate() {
    }
}

