/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.cassandra;

import com.codahale.metrics.Timer;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metrics;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TypeCodec;
import com.datatorrent.api.AutoMetric;
import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.api.annotation.InputPortFieldAnnotation;
import com.datatorrent.common.util.BaseOperator;
import com.datatorrent.contrib.cassandra.CassandraPojoUtils;
import com.datatorrent.contrib.cassandra.CassandraPreparedStatementGenerator;
import com.datatorrent.contrib.cassandra.ConnectionStateManager;
import com.datatorrent.contrib.cassandra.UpsertExecutionContext;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.apex.malhar.lib.wal.FSWindowDataManager;
import org.apache.apex.malhar.lib.wal.WindowDataManager;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public abstract class AbstractUpsertOutputOperator
extends BaseOperator
implements Operator.ActivationListener<Context.OperatorContext>,
Operator.CheckpointNotificationListener {
    protected ConnectionStateManager connectionStateManager;
    private WindowDataManager windowDataManager;
    private long currentWindowId;
    private transient boolean isInSafeMode;
    private transient long reconcilingWindowId;
    private transient boolean isInReconcilingMode;
    protected transient Session session;
    protected transient Cluster cluster;
    transient Map<String, TypeCodec> complexTypeCodecs;
    transient Map<String, Class> userDefinedTypesClass;
    transient Map<String, DataType> columnDefinitions;
    transient Map<String, String> colNamesMap;
    transient Set<String> pkColumnNames;
    transient Set<String> counterColumns;
    transient Set<String> collectionColumns;
    transient Set<String> listColumns;
    transient Set<String> mapColumns;
    transient Set<String> setColumns;
    transient Set<String> userDefinedTypeColumns;
    transient Set<String> regularColumns;
    protected Map<String, Object> getters;
    protected Map<String, TypeCodec> codecsForCassandraColumnNames;
    CassandraPreparedStatementGenerator cassandraPreparedStatementGenerationUtil;
    transient Map<Long, PreparedStatement> preparedStatementTypes;
    transient Class<?> tuplePayloadClass;
    private static final transient Logger LOG = LoggerFactory.getLogger(AbstractUpsertOutputOperator.class);
    private static final String CASSANDRA_CONNECTION_PROPS_FILENAME = "CassandraOutputOperator.properties";
    @AutoMetric
    transient long ignoredRequestsDuetoIfExistsCheck = 0L;
    @AutoMetric
    transient long successfullWrites = 0L;
    @AutoMetric
    long totalWriteRequestsAttempted = 0L;
    @AutoMetric
    transient int numberOfHostsWrittenTo = 0;
    @AutoMetric
    transient double fifteenMinuteWriteRateLatency = 0.0;
    @AutoMetric
    transient double fiveMinuteWriteRateLatency = 0.0;
    @AutoMetric
    transient double oneMinuteWriteRateLatency = 0.0;
    @AutoMetric
    transient double meanWriteRateLatency = 0.0;
    @AutoMetric
    transient long totalIgnoresInThisWindow = 0L;
    @AutoMetric
    long totalIgnoresSinceStart = 0L;
    @AutoMetric
    transient long totalWriteTimeoutsInThisWindow = 0L;
    @AutoMetric
    long totalWriteTimeoutsSinceStart = 0L;
    @AutoMetric
    transient long totalWriteRetriesInThisWindow = 0L;
    @AutoMetric
    long totalWriteRetriesSinceStart = 0L;
    @AutoMetric
    transient long writesWithConsistencyOne = 0L;
    @AutoMetric
    transient long writesWithConsistencyTwo = 0L;
    @AutoMetric
    transient long writesWithConsistencyThree = 0L;
    @AutoMetric
    transient long writesWithConsistencyAll = 0L;
    @AutoMetric
    transient long writesWithConsistencyLocalOne = 0L;
    @AutoMetric
    transient long writesWithConsistencyQuorum = 0L;
    @AutoMetric
    transient long writesWithConsistencyLocalQuorum = 0L;
    @AutoMetric
    transient long writeWithConsistencyLocalSerial = 0L;
    @AutoMetric
    transient long writesWithConsistencyEachQuorum = 0L;
    @AutoMetric
    transient long writesWithConsistencySerial = 0L;
    @AutoMetric
    transient long writesWithConsistencyAny = 0L;
    transient Set<Host> uniqueHostsWrittenToInCurrentWindow;
    @InputPortFieldAnnotation
    public final transient DefaultInputPort<UpsertExecutionContext> input = new DefaultInputPort<UpsertExecutionContext>(){

        public void process(UpsertExecutionContext tuple) {
            if (!AbstractUpsertOutputOperator.this.isEligbleForPassivation(tuple)) {
                return;
            }
            BoundStatement stmnt = AbstractUpsertOutputOperator.this.setDefaultsAndPrepareBoundStatement(tuple);
            ResultSet result = AbstractUpsertOutputOperator.this.session.execute((Statement)stmnt);
            AbstractUpsertOutputOperator.this.updatePerRowMetric(result);
        }
    };

    public void setup(Context.OperatorContext context) {
        super.setup(context);
        this.windowDataManager = this.getWindowDataManager();
        if (this.windowDataManager == null) {
            this.windowDataManager = new FSWindowDataManager();
        }
        this.windowDataManager.setup((Context)context);
    }

    public void teardown() {
        super.teardown();
        if (null != this.windowDataManager) {
            this.windowDataManager.teardown();
        }
    }

    public void beginWindow(long windowId) {
        super.beginWindow(windowId);
        this.totalIgnoresInThisWindow = 0L;
        this.totalWriteTimeoutsInThisWindow = 0L;
        this.totalWriteRetriesInThisWindow = 0L;
        this.uniqueHostsWrittenToInCurrentWindow.clear();
        this.successfullWrites = 0L;
        this.ignoredRequestsDuetoIfExistsCheck = 0L;
        this.writesWithConsistencyOne = 0L;
        this.writesWithConsistencyTwo = 0L;
        this.writesWithConsistencyThree = 0L;
        this.writesWithConsistencyAll = 0L;
        this.writesWithConsistencyLocalOne = 0L;
        this.writesWithConsistencyQuorum = 0L;
        this.writesWithConsistencyLocalQuorum = 0L;
        this.writeWithConsistencyLocalSerial = 0L;
        this.writesWithConsistencyEachQuorum = 0L;
        this.writesWithConsistencySerial = 0L;
        this.writesWithConsistencyAny = 0L;
        this.currentWindowId = windowId;
        if (this.currentWindowId != -1L) {
            if (this.currentWindowId > this.reconcilingWindowId) {
                this.isInSafeMode = false;
                this.isInReconcilingMode = false;
            }
            if (this.currentWindowId == this.reconcilingWindowId) {
                this.isInReconcilingMode = true;
                this.isInSafeMode = false;
            }
            if (this.currentWindowId < this.reconcilingWindowId) {
                this.isInReconcilingMode = false;
                this.isInSafeMode = true;
            }
        }
    }

    public void endWindow() {
        super.endWindow();
        Timer timerForThisWindow = this.session.getCluster().getMetrics().getRequestsTimer();
        this.totalWriteRequestsAttempted += timerForThisWindow.getCount();
        this.numberOfHostsWrittenTo = this.uniqueHostsWrittenToInCurrentWindow.size();
        this.fifteenMinuteWriteRateLatency = timerForThisWindow.getFifteenMinuteRate();
        this.fiveMinuteWriteRateLatency = timerForThisWindow.getFiveMinuteRate();
        this.oneMinuteWriteRateLatency = timerForThisWindow.getOneMinuteRate();
        this.meanWriteRateLatency = timerForThisWindow.getMeanRate();
        Metrics.Errors errors = this.session.getCluster().getMetrics().getErrorMetrics();
        this.totalIgnoresInThisWindow = errors.getIgnores().getCount() - this.totalIgnoresSinceStart;
        this.totalIgnoresSinceStart = errors.getIgnores().getCount();
        this.totalWriteTimeoutsInThisWindow = errors.getWriteTimeouts().getCount() - this.totalWriteTimeoutsSinceStart;
        this.totalWriteTimeoutsSinceStart = errors.getWriteTimeouts().getCount();
        this.totalWriteRetriesInThisWindow = errors.getRetriesOnWriteTimeout().getCount() - this.totalWriteRetriesSinceStart;
        this.totalWriteRetriesSinceStart = errors.getRetriesOnWriteTimeout().getCount();
        try {
            this.windowDataManager.save((Object)this.currentWindowId, this.currentWindowId);
        }
        catch (IOException e) {
            LOG.error("Error while persisting the current window state " + this.currentWindowId + " because " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void activate(Context.OperatorContext context) {
        ConnectionStateManager.ConnectionBuilder connectionBuilder = this.withConnectionBuilder();
        if (connectionBuilder == null) {
            connectionBuilder = this.buildConnectionBuilderFromPropertiesFile();
        }
        Preconditions.checkNotNull((Object)connectionBuilder, (Object)" Connection Builder cannot be null.");
        this.connectionStateManager = connectionBuilder.initialize();
        this.cluster = this.connectionStateManager.getCluster();
        this.session = this.connectionStateManager.getSession();
        Preconditions.checkNotNull((Object)this.session, (Object)"Cassandra session cannot be null");
        this.tuplePayloadClass = this.getPayloadPojoClass();
        this.columnDefinitions = new HashMap<String, DataType>();
        this.counterColumns = new HashSet<String>();
        this.collectionColumns = new HashSet<String>();
        this.pkColumnNames = new HashSet<String>();
        this.listColumns = new HashSet<String>();
        this.mapColumns = new HashSet<String>();
        this.setColumns = new HashSet<String>();
        this.codecsForCassandraColumnNames = new HashMap<String, TypeCodec>();
        this.userDefinedTypeColumns = new HashSet<String>();
        this.regularColumns = new HashSet<String>();
        this.colNamesMap = new HashMap<String, String>();
        this.getters = new HashMap<String, Object>();
        this.userDefinedTypesClass = new HashMap<String, Class>();
        this.uniqueHostsWrittenToInCurrentWindow = new HashSet<Host>();
        this.registerCodecs();
        KeyspaceMetadata keyspaceMetadata = this.cluster.getMetadata().getKeyspace(this.connectionStateManager.getKeyspaceName());
        TableMetadata tableMetadata = keyspaceMetadata.getTable(this.connectionStateManager.getTableName());
        this.registerPrimaryKeyColumnDefinitions(tableMetadata);
        this.registerNonPKColumnDefinitions(tableMetadata);
        this.preparedStatementTypes = new HashMap<Long, PreparedStatement>();
        this.generatePreparedStatements();
        this.registerGettersForPayload();
        this.isInSafeMode = false;
        this.isInReconcilingMode = false;
        this.reconcilingWindowId = -1L;
        if ((Long)context.getValue(Context.OperatorContext.ACTIVATION_WINDOW_ID) != -1L && (Long)context.getValue(Context.OperatorContext.ACTIVATION_WINDOW_ID) < this.windowDataManager.getLargestCompletedWindow()) {
            this.isInSafeMode = true;
            this.reconcilingWindowId = this.windowDataManager.getLargestCompletedWindow() + 1L;
            this.isInReconcilingMode = false;
        }
    }

    public void deactivate() {
        this.connectionStateManager.close();
    }

    public void committed(long windowId) {
        try {
            this.windowDataManager.committed(windowId);
        }
        catch (IOException e) {
            LOG.error("Error while committing the window id " + windowId + " because " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void beforeCheckpoint(long windowId) {
    }

    public void checkpointed(long windowId) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConnectionStateManager.ConnectionBuilder buildConnectionBuilderFromPropertiesFile() {
        ConnectionStateManager.ConnectionBuilder propFileBasedConnectionBuilder = null;
        Properties config = new Properties();
        try (InputStream cassandraPropsFile = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(CASSANDRA_CONNECTION_PROPS_FILENAME);){
            config.load(cassandraPropsFile);
            propFileBasedConnectionBuilder = new ConnectionStateManager.ConnectionBuilder();
            ConnectionStateManager.ConnectionBuilder connectionBuilder = propFileBasedConnectionBuilder.withClusterNameAs(config.getProperty("cluster.name")).withDCNameAs(config.getProperty("dc.name")).withKeySpaceNameAs(config.getProperty("keyspace.name")).withTableNameAs(config.getProperty("table.name")).withSeedNodes(config.getProperty("seednodes"));
            return connectionBuilder;
        }
        catch (Exception ex) {
            LOG.error("Error while trying to load cassandra config from properties file CassandraOutputOperator.properties because " + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    protected boolean isEligbleForPassivation(UpsertExecutionContext tuple) {
        if (this.isInSafeMode) {
            return false;
        }
        if (this.isInReconcilingMode) {
            return this.reconcileRecord(tuple, this.currentWindowId);
        }
        return true;
    }

    private BoundStatement setDefaultsAndPrepareBoundStatement(UpsertExecutionContext tuple) {
        UpsertExecutionContext.ListPlacementStyle listPlacementStyle;
        UpsertExecutionContext.CollectionMutationStyle collectionMutationStyle;
        UpsertExecutionContext.NullHandlingMutationStyle nullHandlingMutationStyle = tuple.getNullHandlingMutationStyle();
        if (UpsertExecutionContext.NullHandlingMutationStyle.UNDEFINED == nullHandlingMutationStyle) {
            nullHandlingMutationStyle = UpsertExecutionContext.NullHandlingMutationStyle.SET_NULL_COLUMNS;
        }
        boolean setNulls = true;
        if (nullHandlingMutationStyle != UpsertExecutionContext.NullHandlingMutationStyle.SET_NULL_COLUMNS) {
            setNulls = false;
        }
        if ((collectionMutationStyle = tuple.getCollectionMutationStyle()) == null || collectionMutationStyle == UpsertExecutionContext.CollectionMutationStyle.UNDEFINED) {
            tuple.setCollectionMutationStyle(UpsertExecutionContext.CollectionMutationStyle.ADD_TO_EXISTING_COLLECTION);
        }
        if ((listPlacementStyle = tuple.getListPlacementStyle()) == null || listPlacementStyle == UpsertExecutionContext.ListPlacementStyle.UNDEFINED) {
            tuple.setListPlacementStyle(UpsertExecutionContext.ListPlacementStyle.APPEND_TO_EXISTING_LIST);
        }
        PreparedStatement preparedStatement = this.resolvePreparedStatementForCurrentExecutionContext(tuple);
        BoundStatement stmnt = this.processPayloadForExecution(preparedStatement, tuple, setNulls);
        if (tuple.isTtlOverridden() || this.connectionStateManager.isTTLSet()) {
            int ttlToUse = this.connectionStateManager.getDefaultTtlInSecs();
            if (tuple.isTtlOverridden()) {
                ttlToUse = tuple.getOverridingTTL();
            }
            stmnt.setInt("ttl", ttlToUse);
        }
        if (tuple.isOverridingConsistencyLevelSet()) {
            ConsistencyLevel currentConsistencyLevel = tuple.getOverridingConsistencyLevel();
            if (currentConsistencyLevel.isSerial()) {
                stmnt.setSerialConsistencyLevel(tuple.getOverridingConsistencyLevel());
            } else {
                stmnt.setConsistencyLevel(tuple.getOverridingConsistencyLevel());
            }
        }
        LOG.debug("Executing statement " + preparedStatement.getQueryString());
        return stmnt;
    }

    private void updatePerRowMetric(ResultSet result) {
        this.uniqueHostsWrittenToInCurrentWindow.add(result.getExecutionInfo().getQueriedHost());
        this.updateConsistencyLevelMetrics(result.getExecutionInfo().getAchievedConsistencyLevel());
        ++this.successfullWrites;
        if (!result.wasApplied()) {
            ++this.ignoredRequestsDuetoIfExistsCheck;
        }
    }

    private void updateConsistencyLevelMetrics(ConsistencyLevel resultConsistencyLevel) {
        if (resultConsistencyLevel == null) {
            return;
        }
        switch (resultConsistencyLevel) {
            case ALL: {
                ++this.writesWithConsistencyAll;
                break;
            }
            case ANY: {
                ++this.writesWithConsistencyAny;
                break;
            }
            case EACH_QUORUM: {
                ++this.writesWithConsistencyEachQuorum;
                break;
            }
            case LOCAL_ONE: {
                ++this.writesWithConsistencyLocalOne;
                break;
            }
            case LOCAL_QUORUM: {
                ++this.writesWithConsistencyLocalQuorum;
                break;
            }
            case LOCAL_SERIAL: {
                ++this.writeWithConsistencyLocalSerial;
                break;
            }
            case ONE: {
                ++this.writesWithConsistencyOne;
                break;
            }
            case QUORUM: {
                ++this.writesWithConsistencyQuorum;
                break;
            }
            case SERIAL: {
                ++this.writesWithConsistencySerial;
                break;
            }
            case THREE: {
                ++this.writesWithConsistencyThree;
                break;
            }
            case TWO: {
                ++this.writesWithConsistencyTwo;
                break;
            }
        }
    }

    private PreparedStatement resolvePreparedStatementForCurrentExecutionContext(UpsertExecutionContext tuple) {
        EnumSet<OperationContext> operationContextValue = EnumSet.noneOf(OperationContext.class);
        UpsertExecutionContext.CollectionMutationStyle collectionMutationStyle = tuple.getCollectionMutationStyle();
        if (collectionMutationStyle != null) {
            if (collectionMutationStyle == UpsertExecutionContext.CollectionMutationStyle.ADD_TO_EXISTING_COLLECTION) {
                operationContextValue.add(OperationContext.COLLECTIONS_APPEND);
            }
            if (collectionMutationStyle == UpsertExecutionContext.CollectionMutationStyle.REMOVE_FROM_EXISTING_COLLECTION) {
                operationContextValue.add(OperationContext.COLLECTIONS_REMOVE);
            }
        }
        UpsertExecutionContext.ListPlacementStyle listPlacementStyle = tuple.getListPlacementStyle();
        boolean isListContextSet = false;
        if (listPlacementStyle != null && collectionMutationStyle == UpsertExecutionContext.CollectionMutationStyle.ADD_TO_EXISTING_COLLECTION) {
            if (listPlacementStyle == UpsertExecutionContext.ListPlacementStyle.APPEND_TO_EXISTING_LIST) {
                operationContextValue.add(OperationContext.LIST_APPEND);
                isListContextSet = true;
            }
            if (listPlacementStyle == UpsertExecutionContext.ListPlacementStyle.PREPEND_TO_EXISTING_LIST) {
                operationContextValue.add(OperationContext.LIST_PREPEND);
                isListContextSet = true;
            }
        }
        if (!isListContextSet) {
            operationContextValue.add(OperationContext.LIST_APPEND);
        }
        if (this.connectionStateManager.isTTLSet() || tuple.isTtlOverridden()) {
            operationContextValue.add(OperationContext.TTL_SET);
        } else {
            operationContextValue.add(OperationContext.TTL_NOT_SET);
        }
        if (tuple.isUpdateOnlyIfPrimaryKeyExists()) {
            operationContextValue.add(OperationContext.IF_EXISTS_CHECK_PRESENT);
        } else {
            operationContextValue.add(OperationContext.IF_EXISTS_CHECK_ABSENT);
        }
        return this.preparedStatementTypes.get(CassandraPreparedStatementGenerator.getSlotIndexForMutationContextPreparedStatement(operationContextValue));
    }

    private BoundStatement processPayloadForExecution(PreparedStatement ps, UpsertExecutionContext tuple, boolean setNulls) {
        BoundStatement boundStatement = ps.bind();
        Object pojoPayload = tuple.getPayload();
        for (String cassandraColName : this.getters.keySet()) {
            DataType dataType = this.columnDefinitions.get(cassandraColName);
            CassandraPojoUtils.populateBoundStatementWithValue(boundStatement, this.getters, dataType, cassandraColName, pojoPayload, setNulls, this.codecsForCassandraColumnNames);
        }
        return boundStatement;
    }

    private void registerGettersForPayload() {
        Field[] classFields = this.tuplePayloadClass.getDeclaredFields();
        HashSet<String> allColNames = new HashSet<String>();
        HashMap<String, DataType> dataTypeMap = new HashMap<String, DataType>();
        Map<String, String> overridingColnamesMap = this.getPojoFieldNameToCassandraColumnNameOverride();
        if (overridingColnamesMap == null) {
            overridingColnamesMap = new HashMap<String, String>();
        }
        allColNames.addAll(this.pkColumnNames);
        allColNames.addAll(this.regularColumns);
        HashSet<String> normalizedColNames = new HashSet<String>();
        for (String aCol : allColNames) {
            normalizedColNames.add(aCol.toLowerCase());
            dataTypeMap.put(aCol.toLowerCase(), this.columnDefinitions.get(aCol));
            this.colNamesMap.put(aCol.toLowerCase(), aCol);
            this.codecsForCassandraColumnNames.put(aCol, this.complexTypeCodecs.get(aCol.toLowerCase()));
        }
        for (Field aField : classFields) {
            String aFieldName = aField.getName();
            if (!normalizedColNames.contains(aFieldName.toLowerCase()) && !overridingColnamesMap.containsKey(aFieldName)) continue;
            String getterExpr = aFieldName;
            DataType returnDataTypeOfGetter = (DataType)dataTypeMap.get(aFieldName.toLowerCase());
            if (returnDataTypeOfGetter == null) {
                returnDataTypeOfGetter = (DataType)dataTypeMap.get(overridingColnamesMap.get(aFieldName));
            }
            Object getter = CassandraPojoUtils.resolveGetterForField(this.tuplePayloadClass, getterExpr, returnDataTypeOfGetter, this.userDefinedTypesClass);
            String resolvedColumnName = this.colNamesMap.get(aFieldName.toLowerCase());
            if (overridingColnamesMap.containsKey(aFieldName)) {
                resolvedColumnName = overridingColnamesMap.get(aFieldName);
            }
            this.getters.put(resolvedColumnName, getter);
        }
    }

    private void registerCodecs() {
        this.complexTypeCodecs = this.getCodecsForUserDefinedTypes();
        if (this.complexTypeCodecs != null) {
            CodecRegistry registry = this.cluster.getConfiguration().getCodecRegistry();
            if (this.cluster.getConfiguration().getProtocolOptions().getProtocolVersion().toInt() < 4) {
                LOG.error("Custom codecs are not supported for protocol version < 4");
                throw new RuntimeException("Custom codecs are not supported for protocol version < 4");
            }
            for (String typeCodecStr : this.complexTypeCodecs.keySet()) {
                TypeCodec codec = this.complexTypeCodecs.get(typeCodecStr);
                registry.register(codec);
                this.userDefinedTypesClass.put(typeCodecStr, codec.getJavaType().getRawType());
            }
        } else {
            this.complexTypeCodecs = new HashMap<String, TypeCodec>();
        }
    }

    private void registerNonPKColumnDefinitions(TableMetadata tableMetadata) {
        List colInfoForTable = tableMetadata.getColumns();
        for (ColumnMetadata aColumnDefinition : colInfoForTable) {
            if (aColumnDefinition.getType().isCollection()) {
                this.collectionColumns.add(aColumnDefinition.getName());
            }
            if (!this.pkColumnNames.contains(aColumnDefinition.getName())) {
                this.columnDefinitions.put(aColumnDefinition.getName(), aColumnDefinition.getType());
                this.regularColumns.add(aColumnDefinition.getName());
            }
            this.parseForSpecialDataType(aColumnDefinition);
        }
    }

    private void parseForSpecialDataType(ColumnMetadata aColumnDefinition) {
        switch (aColumnDefinition.getType().getName()) {
            case COUNTER: {
                this.counterColumns.add(aColumnDefinition.getName());
                break;
            }
            case MAP: {
                this.mapColumns.add(aColumnDefinition.getName());
                break;
            }
            case SET: {
                this.setColumns.add(aColumnDefinition.getName());
                break;
            }
            case LIST: {
                this.listColumns.add(aColumnDefinition.getName());
                break;
            }
            case UDT: {
                this.userDefinedTypeColumns.add(aColumnDefinition.getName());
                break;
            }
        }
    }

    private void registerPrimaryKeyColumnDefinitions(TableMetadata tableMetadata) {
        List primaryKeyColumns = tableMetadata.getPrimaryKey();
        for (ColumnMetadata primaryColumn : primaryKeyColumns) {
            this.columnDefinitions.put(primaryColumn.getName(), primaryColumn.getType());
            this.pkColumnNames.add(primaryColumn.getName());
            this.parseForSpecialDataType(primaryColumn);
        }
    }

    private void generatePreparedStatements() {
        this.cassandraPreparedStatementGenerationUtil = new CassandraPreparedStatementGenerator(this.pkColumnNames, this.counterColumns, this.listColumns, this.mapColumns, this.setColumns, this.columnDefinitions);
        this.cassandraPreparedStatementGenerationUtil.generatePreparedStatements(this.session, this.preparedStatementTypes, this.connectionStateManager.getKeyspaceName(), this.connectionStateManager.getTableName());
    }

    public Map<String, DataType> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    public void setColumnDefinitions(Map<String, DataType> columnDefinitions) {
        this.columnDefinitions = columnDefinitions;
    }

    public Map<String, Class> getUserDefinedTypesClass() {
        return this.userDefinedTypesClass;
    }

    public void setUserDefinedTypesClass(Map<String, Class> userDefinedTypesClass) {
        this.userDefinedTypesClass = userDefinedTypesClass;
    }

    public Set<String> getPkColumnNames() {
        return this.pkColumnNames;
    }

    public void setPkColumnNames(Set<String> pkColumnNames) {
        this.pkColumnNames = pkColumnNames;
    }

    public Set<String> getCounterColumns() {
        return this.counterColumns;
    }

    public void setCounterColumns(Set<String> counterColumns) {
        this.counterColumns = counterColumns;
    }

    public Set<String> getCollectionColumns() {
        return this.collectionColumns;
    }

    public void setCollectionColumns(Set<String> collectionColumns) {
        this.collectionColumns = collectionColumns;
    }

    public Set<String> getListColumns() {
        return this.listColumns;
    }

    public void setListColumns(Set<String> listColumns) {
        this.listColumns = listColumns;
    }

    public Set<String> getMapColumns() {
        return this.mapColumns;
    }

    public void setMapColumns(Set<String> mapColumns) {
        this.mapColumns = mapColumns;
    }

    public Set<String> getSetColumns() {
        return this.setColumns;
    }

    public void setSetColumns(Set<String> setColumns) {
        this.setColumns = setColumns;
    }

    public Set<String> getUserDefinedTypeColumns() {
        return this.userDefinedTypeColumns;
    }

    public void setUserDefinedTypeColumns(Set<String> userDefinedTypeColumns) {
        this.userDefinedTypeColumns = userDefinedTypeColumns;
    }

    public Set<String> getRegularColumns() {
        return this.regularColumns;
    }

    public void setRegularColumns(Set<String> regularColumns) {
        this.regularColumns = regularColumns;
    }

    public Map<Long, PreparedStatement> getPreparedStatementTypes() {
        return this.preparedStatementTypes;
    }

    public void setPreparedStatementTypes(Map<Long, PreparedStatement> preparedStatementTypes) {
        this.preparedStatementTypes = preparedStatementTypes;
    }

    public Map<String, Object> getGetters() {
        return this.getters;
    }

    public void setGetters(Map<String, Object> getters) {
        this.getters = getters;
    }

    public ConnectionStateManager getConnectionStateManager() {
        return this.connectionStateManager;
    }

    public void setConnectionStateManager(ConnectionStateManager connectionStateManager) {
        this.connectionStateManager = connectionStateManager;
    }

    public WindowDataManager getWindowDataManager() {
        return this.windowDataManager;
    }

    public void setWindowDataManager(WindowDataManager windowDataManager) {
        this.windowDataManager = windowDataManager;
    }

    public ConnectionStateManager.ConnectionBuilder withConnectionBuilder() {
        return null;
    }

    public abstract Map<String, TypeCodec> getCodecsForUserDefinedTypes();

    public abstract Class getPayloadPojoClass();

    protected Map<String, String> getPojoFieldNameToCassandraColumnNameOverride() {
        return new HashMap<String, String>();
    }

    abstract boolean reconcileRecord(Object var1, long var2);

    static enum OperationContext {
        UNDEFINED,
        COLLECTIONS_APPEND,
        COLLECTIONS_REMOVE,
        LIST_APPEND,
        LIST_PREPEND,
        TTL_SET,
        TTL_NOT_SET,
        IF_EXISTS_CHECK_PRESENT,
        IF_EXISTS_CHECK_ABSENT;

    }
}

