/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.TypeCodec;
import com.datatorrent.lib.util.PojoUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class CassandraPojoUtils {
    public static Object resolveGetterForField(Class tuplePayloadClass, String getterExpr, DataType returnDataTypeOfGetter, Map<String, Class> userDefinedTypesClass) {
        PojoUtils.GetterInt getter = null;
        switch (returnDataTypeOfGetter.getName()) {
            case INT: {
                getter = PojoUtils.createGetterInt((Class)tuplePayloadClass, (String)getterExpr);
                break;
            }
            case BIGINT: 
            case COUNTER: {
                getter = PojoUtils.createGetterLong((Class)tuplePayloadClass, (String)getterExpr);
                break;
            }
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                getter = PojoUtils.createGetter((Class)tuplePayloadClass, (String)getterExpr, String.class);
                break;
            }
            case BOOLEAN: {
                getter = PojoUtils.createGetterBoolean((Class)tuplePayloadClass, (String)getterExpr);
                break;
            }
            case FLOAT: {
                getter = PojoUtils.createGetterFloat((Class)tuplePayloadClass, (String)getterExpr);
                break;
            }
            case DOUBLE: {
                getter = PojoUtils.createGetterDouble((Class)tuplePayloadClass, (String)getterExpr);
                break;
            }
            case DECIMAL: {
                getter = PojoUtils.createGetter((Class)tuplePayloadClass, (String)getterExpr, BigDecimal.class);
                break;
            }
            case SET: {
                getter = PojoUtils.createGetter((Class)tuplePayloadClass, (String)getterExpr, Set.class);
                break;
            }
            case MAP: {
                getter = PojoUtils.createGetter((Class)tuplePayloadClass, (String)getterExpr, Map.class);
                break;
            }
            case LIST: {
                getter = PojoUtils.createGetter((Class)tuplePayloadClass, (String)getterExpr, List.class);
                break;
            }
            case TIMESTAMP: {
                getter = PojoUtils.createGetter((Class)tuplePayloadClass, (String)getterExpr, Date.class);
                break;
            }
            case UUID: {
                getter = PojoUtils.createGetter((Class)tuplePayloadClass, (String)getterExpr, UUID.class);
                break;
            }
            case UDT: {
                getter = PojoUtils.createGetter((Class)tuplePayloadClass, (String)getterExpr, (Class)userDefinedTypesClass.get(getterExpr));
                break;
            }
            default: {
                getter = PojoUtils.createGetter((Class)tuplePayloadClass, (String)getterExpr, Object.class);
            }
        }
        return getter;
    }

    public static void populateBoundStatementWithValue(BoundStatement boundStatement, Map<String, Object> getters, DataType dataType, String cassandraColName, Object pojoPayload, boolean setNulls, Map<String, TypeCodec> codecsForCassandraColumnNames) {
        switch (dataType.getName()) {
            case BOOLEAN: {
                PojoUtils.GetterBoolean boolGetter = (PojoUtils.GetterBoolean)getters.get(cassandraColName);
                if (boolGetter != null) {
                    boolean bool = boolGetter.get(pojoPayload);
                    boundStatement.setBool(cassandraColName, bool);
                    break;
                }
                boundStatement.unset(cassandraColName);
                break;
            }
            case INT: {
                PojoUtils.GetterInt inGetter = (PojoUtils.GetterInt)getters.get(cassandraColName);
                if (inGetter != null) {
                    int intValue = inGetter.get(pojoPayload);
                    boundStatement.setInt(cassandraColName, intValue);
                    break;
                }
                boundStatement.unset(cassandraColName);
                break;
            }
            case BIGINT: 
            case COUNTER: {
                PojoUtils.GetterLong longGetter = (PojoUtils.GetterLong)getters.get(cassandraColName);
                if (longGetter != null) {
                    long longValue = longGetter.get(pojoPayload);
                    boundStatement.setLong(cassandraColName, longValue);
                    break;
                }
                boundStatement.unset(cassandraColName);
                break;
            }
            case FLOAT: {
                PojoUtils.GetterFloat floatGetter = (PojoUtils.GetterFloat)getters.get(cassandraColName);
                if (floatGetter != null) {
                    float floatValue = floatGetter.get(pojoPayload);
                    boundStatement.setFloat(cassandraColName, floatValue);
                    break;
                }
                boundStatement.unset(cassandraColName);
                break;
            }
            case DOUBLE: {
                PojoUtils.GetterDouble doubleGetter = (PojoUtils.GetterDouble)getters.get(cassandraColName);
                if (doubleGetter != null) {
                    double doubleValue = doubleGetter.get(pojoPayload);
                    boundStatement.setDouble(cassandraColName, doubleValue);
                    break;
                }
                boundStatement.unset(cassandraColName);
                break;
            }
            case DECIMAL: {
                PojoUtils.Getter bigDecimalGetter = (PojoUtils.Getter)getters.get(cassandraColName);
                if (bigDecimalGetter != null) {
                    BigDecimal decimal = (BigDecimal)bigDecimalGetter.get(pojoPayload);
                    if (decimal == null) {
                        if (!setNulls) {
                            boundStatement.unset(cassandraColName);
                            break;
                        }
                        boundStatement.setDecimal(cassandraColName, null);
                        break;
                    }
                    boundStatement.setDecimal(cassandraColName, decimal);
                    break;
                }
                boundStatement.unset(cassandraColName);
                break;
            }
            case UUID: {
                PojoUtils.Getter uuidGetter = (PojoUtils.Getter)getters.get(cassandraColName);
                if (uuidGetter != null) {
                    UUID uuid = (UUID)uuidGetter.get(pojoPayload);
                    if (uuid == null) {
                        if (!setNulls) {
                            boundStatement.unset(cassandraColName);
                            break;
                        }
                        boundStatement.setUUID(cassandraColName, null);
                        break;
                    }
                    boundStatement.setUUID(cassandraColName, uuid);
                    break;
                }
                boundStatement.unset(cassandraColName);
                break;
            }
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                PojoUtils.Getter stringGetter = (PojoUtils.Getter)getters.get(cassandraColName);
                if (stringGetter != null) {
                    String ascii = (String)stringGetter.get(pojoPayload);
                    if (ascii == null) {
                        if (!setNulls) {
                            boundStatement.unset(cassandraColName);
                            break;
                        }
                        boundStatement.setString(cassandraColName, null);
                        break;
                    }
                    boundStatement.setString(cassandraColName, ascii);
                    break;
                }
                boundStatement.unset(cassandraColName);
                break;
            }
            case SET: {
                PojoUtils.Getter getterForSet = (PojoUtils.Getter)getters.get(cassandraColName);
                if (getterForSet != null) {
                    Set set = (Set)getterForSet.get(pojoPayload);
                    if (set == null) {
                        if (!setNulls) {
                            boundStatement.unset(cassandraColName);
                            break;
                        }
                        boundStatement.setSet(cassandraColName, null);
                        break;
                    }
                    boundStatement.setSet(cassandraColName, set);
                    break;
                }
                boundStatement.unset(cassandraColName);
                break;
            }
            case MAP: {
                PojoUtils.Getter mapGetter = (PojoUtils.Getter)getters.get(cassandraColName);
                if (mapGetter != null) {
                    Map map = (Map)mapGetter.get(pojoPayload);
                    if (map == null) {
                        if (!setNulls) {
                            boundStatement.unset(cassandraColName);
                            break;
                        }
                        boundStatement.setMap(cassandraColName, null);
                        break;
                    }
                    boundStatement.setMap(cassandraColName, map);
                    break;
                }
                boundStatement.unset(cassandraColName);
                break;
            }
            case LIST: {
                PojoUtils.Getter listGetter = (PojoUtils.Getter)getters.get(cassandraColName);
                if (listGetter != null) {
                    List list = (List)listGetter.get(pojoPayload);
                    if (list == null) {
                        if (!setNulls) {
                            boundStatement.unset(cassandraColName);
                            break;
                        }
                        boundStatement.setList(cassandraColName, null);
                        break;
                    }
                    boundStatement.setList(cassandraColName, list);
                    break;
                }
                boundStatement.unset(cassandraColName);
                break;
            }
            case TIMESTAMP: {
                PojoUtils.Getter dateGetter = (PojoUtils.Getter)getters.get(cassandraColName);
                if (dateGetter != null) {
                    Date date = (Date)dateGetter.get(pojoPayload);
                    if (date == null) {
                        if (!setNulls) {
                            boundStatement.unset(cassandraColName);
                            break;
                        }
                        boundStatement.setMap(cassandraColName, null);
                        break;
                    }
                    boundStatement.setDate(cassandraColName, LocalDate.fromMillisSinceEpoch((long)date.getTime()));
                    break;
                }
                boundStatement.unset(cassandraColName);
                break;
            }
            case UDT: {
                PojoUtils.Getter udtGetter = (PojoUtils.Getter)getters.get(cassandraColName);
                if (udtGetter != null) {
                    Object udtPayload = udtGetter.get(pojoPayload);
                    if (udtPayload == null) {
                        if (!setNulls) {
                            boundStatement.unset(cassandraColName);
                            break;
                        }
                        boundStatement.setUDTValue(cassandraColName, null);
                        break;
                    }
                    boundStatement.set(cassandraColName, udtPayload, codecsForCassandraColumnNames.get(cassandraColName).getJavaType().getRawType());
                    break;
                }
                boundStatement.unset(cassandraColName);
                break;
            }
            default: {
                throw new RuntimeException("Type not supported for " + dataType.getName());
            }
        }
    }
}

