/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.cassandra;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datatorrent.contrib.cassandra.AbstractUpsertOutputOperator;
import com.datatorrent.contrib.cassandra.UpsertExecutionContext;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraPreparedStatementGenerator {
    private Set<String> pkColumnNames;
    private Set<String> counterColumns;
    private Set<String> listColumns;
    private Set<String> mapColumns;
    private Set<String> setColumns;
    private Map<String, DataType> columnDefinitions;
    private static final transient Logger LOG = LoggerFactory.getLogger(CassandraPreparedStatementGenerator.class);
    public static final String TTL_PARAM_NAME = "ttl";

    public CassandraPreparedStatementGenerator(Set<String> pkColumnNames, Set<String> counterColumns, Set<String> listColumns, Set<String> mapColumns, Set<String> setColumns, Map<String, DataType> columnDefinitions) {
        this.pkColumnNames = pkColumnNames;
        this.counterColumns = counterColumns;
        this.listColumns = listColumns;
        this.mapColumns = mapColumns;
        this.setColumns = setColumns;
        this.columnDefinitions = columnDefinitions;
    }

    public void generatePreparedStatements(Session session, Map<Long, PreparedStatement> preparedStatementTypes, String keyspaceName, String tableName) {
        Map<Long, String> stringsWithoutPKAndExistsClauses = this.generatePreparedStatementsQueryStrings(keyspaceName, tableName);
        String ifExistsClause = " IF EXISTS";
        HashMap<Long, String> finalSetOfQueryStrings = new HashMap<Long, String>();
        for (Long currentIndexPos : stringsWithoutPKAndExistsClauses.keySet()) {
            StringBuilder aQueryStub = new StringBuilder(stringsWithoutPKAndExistsClauses.get(currentIndexPos));
            this.buildWhereClauseForPrimaryKeys(aQueryStub);
            finalSetOfQueryStrings.put(currentIndexPos + CassandraPreparedStatementGenerator.getSlotIndexForMutationContextPreparedStatement(EnumSet.of(AbstractUpsertOutputOperator.OperationContext.IF_EXISTS_CHECK_ABSENT)), aQueryStub.toString());
            if (this.counterColumns.size() != 0) continue;
            finalSetOfQueryStrings.put(currentIndexPos + CassandraPreparedStatementGenerator.getSlotIndexForMutationContextPreparedStatement(EnumSet.of(AbstractUpsertOutputOperator.OperationContext.IF_EXISTS_CHECK_PRESENT)), aQueryStub.toString() + ifExistsClause);
        }
        for (Long currentIndexPos : finalSetOfQueryStrings.keySet()) {
            String currentQueryStr = (String)finalSetOfQueryStrings.get(currentIndexPos);
            LOG.info("Registering query support for " + currentQueryStr);
            PreparedStatement preparedStatementForThisQuery = session.prepare(currentQueryStr);
            preparedStatementTypes.put(currentIndexPos, preparedStatementForThisQuery);
        }
    }

    private void buildWhereClauseForPrimaryKeys(StringBuilder queryExpression) {
        queryExpression.append(" WHERE ");
        int count = 0;
        for (String pkColName : this.pkColumnNames) {
            if (count > 0) {
                queryExpression.append(" AND ");
            }
            ++count;
            queryExpression.append(" ").append(pkColName).append(" = :").append(pkColName);
        }
    }

    private void buildQueryStringForTTLSetCollectionsAppendAndListPrepend(StringBuilder updateQueryRoot, String ttlSetString, Map<Long, String> queryStrings) {
        StringBuilder queryExpTTLSetCollAppendListPrepend = new StringBuilder(updateQueryRoot.toString());
        queryExpTTLSetCollAppendListPrepend.append(ttlSetString);
        this.buildNonPKColumnsExpression(queryExpTTLSetCollAppendListPrepend, UpsertExecutionContext.ListPlacementStyle.PREPEND_TO_EXISTING_LIST, UpsertExecutionContext.CollectionMutationStyle.ADD_TO_EXISTING_COLLECTION);
        queryStrings.put(CassandraPreparedStatementGenerator.getSlotIndexForMutationContextPreparedStatement(EnumSet.of(AbstractUpsertOutputOperator.OperationContext.TTL_SET, AbstractUpsertOutputOperator.OperationContext.COLLECTIONS_APPEND, AbstractUpsertOutputOperator.OperationContext.LIST_PREPEND)), queryExpTTLSetCollAppendListPrepend.toString());
    }

    private void buildQueryStringForTTLSetCollectionsAppendAndListAppend(StringBuilder updateQueryRoot, String ttlSetString, Map<Long, String> queryStrings) {
        StringBuilder queryExpTTLSetCollAppendListAppend = new StringBuilder(updateQueryRoot.toString());
        queryExpTTLSetCollAppendListAppend.append(ttlSetString);
        this.buildNonPKColumnsExpression(queryExpTTLSetCollAppendListAppend, UpsertExecutionContext.ListPlacementStyle.APPEND_TO_EXISTING_LIST, UpsertExecutionContext.CollectionMutationStyle.ADD_TO_EXISTING_COLLECTION);
        queryStrings.put(CassandraPreparedStatementGenerator.getSlotIndexForMutationContextPreparedStatement(EnumSet.of(AbstractUpsertOutputOperator.OperationContext.TTL_SET, AbstractUpsertOutputOperator.OperationContext.COLLECTIONS_APPEND, AbstractUpsertOutputOperator.OperationContext.LIST_APPEND)), queryExpTTLSetCollAppendListAppend.toString());
    }

    private void buildQueryStringForTTLSetCollectionsRemove(StringBuilder updateQueryRoot, String ttlSetString, Map<Long, String> queryStrings) {
        StringBuilder queryExpTTLSetCollRemove = new StringBuilder(updateQueryRoot.toString());
        queryExpTTLSetCollRemove.append(ttlSetString);
        this.buildNonPKColumnsExpression(queryExpTTLSetCollRemove, UpsertExecutionContext.ListPlacementStyle.APPEND_TO_EXISTING_LIST, UpsertExecutionContext.CollectionMutationStyle.REMOVE_FROM_EXISTING_COLLECTION);
        queryStrings.put(CassandraPreparedStatementGenerator.getSlotIndexForMutationContextPreparedStatement(EnumSet.of(AbstractUpsertOutputOperator.OperationContext.TTL_SET, AbstractUpsertOutputOperator.OperationContext.COLLECTIONS_REMOVE, AbstractUpsertOutputOperator.OperationContext.LIST_APPEND)), queryExpTTLSetCollRemove.toString());
    }

    private void buildQueryStringForTTLNotSetCollectionsAppendWithListPrepend(StringBuilder updateQueryRoot, Map<Long, String> queryStrings) {
        StringBuilder queryExpTTLNotSetCollAppendListPrepend = new StringBuilder(updateQueryRoot.toString());
        queryExpTTLNotSetCollAppendListPrepend.append(" SET ");
        this.buildNonPKColumnsExpression(queryExpTTLNotSetCollAppendListPrepend, UpsertExecutionContext.ListPlacementStyle.PREPEND_TO_EXISTING_LIST, UpsertExecutionContext.CollectionMutationStyle.ADD_TO_EXISTING_COLLECTION);
        queryStrings.put(CassandraPreparedStatementGenerator.getSlotIndexForMutationContextPreparedStatement(EnumSet.of(AbstractUpsertOutputOperator.OperationContext.TTL_NOT_SET, AbstractUpsertOutputOperator.OperationContext.COLLECTIONS_APPEND, AbstractUpsertOutputOperator.OperationContext.LIST_PREPEND)), queryExpTTLNotSetCollAppendListPrepend.toString());
    }

    private void buildQueryStringForTTLNotSetCollectionsAppendWithListAppend(StringBuilder updateQueryRoot, Map<Long, String> queryStrings) {
        StringBuilder queryExpTTLNotSetCollAppendListAppend = new StringBuilder(updateQueryRoot.toString());
        queryExpTTLNotSetCollAppendListAppend.append(" SET ");
        this.buildNonPKColumnsExpression(queryExpTTLNotSetCollAppendListAppend, UpsertExecutionContext.ListPlacementStyle.APPEND_TO_EXISTING_LIST, UpsertExecutionContext.CollectionMutationStyle.ADD_TO_EXISTING_COLLECTION);
        queryStrings.put(CassandraPreparedStatementGenerator.getSlotIndexForMutationContextPreparedStatement(EnumSet.of(AbstractUpsertOutputOperator.OperationContext.TTL_NOT_SET, AbstractUpsertOutputOperator.OperationContext.COLLECTIONS_APPEND, AbstractUpsertOutputOperator.OperationContext.LIST_APPEND)), queryExpTTLNotSetCollAppendListAppend.toString());
    }

    private void buildQueryStringForTTLNotSetCollectionsRemove(StringBuilder updateQueryRoot, Map<Long, String> queryStrings) {
        StringBuilder queryExpTTLNotSetCollRemove = new StringBuilder(updateQueryRoot.toString());
        queryExpTTLNotSetCollRemove.append(" SET ");
        this.buildNonPKColumnsExpression(queryExpTTLNotSetCollRemove, UpsertExecutionContext.ListPlacementStyle.APPEND_TO_EXISTING_LIST, UpsertExecutionContext.CollectionMutationStyle.REMOVE_FROM_EXISTING_COLLECTION);
        queryStrings.put(CassandraPreparedStatementGenerator.getSlotIndexForMutationContextPreparedStatement(EnumSet.of(AbstractUpsertOutputOperator.OperationContext.TTL_NOT_SET, AbstractUpsertOutputOperator.OperationContext.COLLECTIONS_REMOVE, AbstractUpsertOutputOperator.OperationContext.LIST_APPEND)), queryExpTTLNotSetCollRemove.toString());
    }

    private Map<Long, String> generatePreparedStatementsQueryStrings(String keyspaceName, String tableName) {
        HashMap<Long, String> queryStrings = new HashMap<Long, String>();
        StringBuilder updateQueryRoot = new StringBuilder(" UPDATE " + keyspaceName + "." + tableName + " ");
        String ttlSetString = " USING ttl :ttl SET ";
        this.buildQueryStringForTTLSetCollectionsAppendAndListPrepend(updateQueryRoot, ttlSetString, queryStrings);
        this.buildQueryStringForTTLSetCollectionsAppendAndListAppend(updateQueryRoot, ttlSetString, queryStrings);
        this.buildQueryStringForTTLSetCollectionsRemove(updateQueryRoot, ttlSetString, queryStrings);
        this.buildQueryStringForTTLNotSetCollectionsAppendWithListPrepend(updateQueryRoot, queryStrings);
        this.buildQueryStringForTTLNotSetCollectionsAppendWithListAppend(updateQueryRoot, queryStrings);
        this.buildQueryStringForTTLNotSetCollectionsRemove(updateQueryRoot, queryStrings);
        return queryStrings;
    }

    public static long getSlotIndexForMutationContextPreparedStatement(EnumSet<AbstractUpsertOutputOperator.OperationContext> context) {
        Iterator itrForContexts = context.iterator();
        long indexValue = 0L;
        while (itrForContexts.hasNext()) {
            AbstractUpsertOutputOperator.OperationContext aContext = (AbstractUpsertOutputOperator.OperationContext)((Object)itrForContexts.next());
            indexValue = (long)((double)indexValue + Math.pow(10.0, aContext.ordinal()));
        }
        return indexValue;
    }

    private void buildNonPKColumnsExpression(StringBuilder queryExpression, UpsertExecutionContext.ListPlacementStyle listPlacementStyle, UpsertExecutionContext.CollectionMutationStyle collectionMutationStyle) {
        int count = 0;
        for (String colNameEntry : this.columnDefinitions.keySet()) {
            if (this.pkColumnNames.contains(colNameEntry)) continue;
            if (count > 0) {
                queryExpression.append(",");
            }
            ++count;
            if (this.counterColumns.contains(colNameEntry)) {
                queryExpression.append(" " + colNameEntry + " = " + colNameEntry + " + :" + colNameEntry);
                continue;
            }
            DataType dataType = this.columnDefinitions.get(colNameEntry);
            if (!dataType.isCollection() && !this.counterColumns.contains(colNameEntry)) {
                queryExpression.append(" " + colNameEntry + " = :" + colNameEntry);
                continue;
            }
            if (dataType.isCollection() && !dataType.isFrozen()) {
                if (collectionMutationStyle == UpsertExecutionContext.CollectionMutationStyle.REMOVE_FROM_EXISTING_COLLECTION) {
                    queryExpression.append(" " + colNameEntry + " = " + colNameEntry + " - :" + colNameEntry);
                }
                if (collectionMutationStyle != UpsertExecutionContext.CollectionMutationStyle.ADD_TO_EXISTING_COLLECTION) continue;
                if (this.setColumns.contains(colNameEntry) || this.mapColumns.contains(colNameEntry)) {
                    queryExpression.append(" " + colNameEntry + " = " + colNameEntry + " + :" + colNameEntry);
                }
                if (this.listColumns.contains(colNameEntry) && listPlacementStyle == UpsertExecutionContext.ListPlacementStyle.APPEND_TO_EXISTING_LIST) {
                    queryExpression.append(" " + colNameEntry + " = " + colNameEntry + " + :" + colNameEntry);
                }
                if (!this.listColumns.contains(colNameEntry) || listPlacementStyle != UpsertExecutionContext.ListPlacementStyle.PREPEND_TO_EXISTING_LIST) continue;
                queryExpression.append(" " + colNameEntry + " = :" + colNameEntry + " + " + colNameEntry);
                continue;
            }
            if (!dataType.isCollection() || !dataType.isFrozen()) continue;
            queryExpression.append(" " + colNameEntry + " = :" + colNameEntry);
        }
    }
}

