/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.cassandra;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datatorrent.contrib.cassandra.CassandraStore;
import com.datatorrent.lib.db.TransactionableStore;
import javax.annotation.Nonnull;

public class CassandraTransactionalStore
extends CassandraStore
implements TransactionableStore {
    public static String DEFAULT_APP_ID_COL = "dt_app_id";
    public static String DEFAULT_OPERATOR_ID_COL = "dt_operator_id";
    public static String DEFAULT_WINDOW_COL = "dt_window";
    public static String DEFAULT_META_TABLE = "dt_meta";
    @Nonnull
    protected String metaTableAppIdColumn;
    @Nonnull
    protected String metaTableOperatorIdColumn;
    @Nonnull
    protected String metaTableWindowColumn;
    @Nonnull
    private String metaTable = DEFAULT_META_TABLE;
    private transient boolean inTransaction = false;
    private transient PreparedStatement lastWindowFetchCommand;
    private transient PreparedStatement lastWindowUpdateCommand;
    private transient PreparedStatement lastWindowDeleteCommand;
    private transient Statement lastWindowFetchStatement;
    private transient Statement lastWindowUpdateStatement;
    private transient Statement lastWindowDeleteStatement;
    protected transient BatchStatement batchCommand;

    public CassandraTransactionalStore() {
        this.metaTableAppIdColumn = DEFAULT_APP_ID_COL;
        this.metaTableOperatorIdColumn = DEFAULT_OPERATOR_ID_COL;
        this.metaTableWindowColumn = DEFAULT_WINDOW_COL;
        this.batchCommand = new BatchStatement();
    }

    public void setMetaTable(@Nonnull String metaTable) {
        this.metaTable = metaTable;
    }

    public void setMetaTableAppIdColumn(@Nonnull String appIdColumn) {
        this.metaTableAppIdColumn = appIdColumn;
    }

    public void setMetaTableOperatorIdColumn(@Nonnull String operatorIdColumn) {
        this.metaTableOperatorIdColumn = operatorIdColumn;
    }

    public void setMetaTableWindowColumn(@Nonnull String windowColumn) {
        this.metaTableWindowColumn = windowColumn;
    }

    public Statement getLastWindowUpdateStatement() {
        return this.lastWindowUpdateStatement;
    }

    public BatchStatement getBatchCommand() {
        return this.batchCommand;
    }

    @Override
    public void connect() {
        super.connect();
        try {
            String command = "SELECT " + this.metaTableWindowColumn + " FROM " + this.keyspace + "." + this.metaTable + " WHERE " + this.metaTableAppIdColumn + " = ? AND " + this.metaTableOperatorIdColumn + " = ?";
            logger.debug(command);
            this.lastWindowFetchCommand = this.session.prepare(command);
            command = "UPDATE " + this.keyspace + "." + this.metaTable + " SET " + this.metaTableWindowColumn + " = ? where " + this.metaTableAppIdColumn + " = ? " + " and " + this.metaTableOperatorIdColumn + " = ?";
            logger.debug(command);
            this.lastWindowUpdateCommand = this.session.prepare(command);
            command = "DELETE FROM " + this.keyspace + "." + this.metaTable + " where " + this.metaTableAppIdColumn + " = ? and " + this.metaTableOperatorIdColumn + " = ?";
            logger.debug(command);
            this.lastWindowDeleteCommand = this.session.prepare(command);
        }
        catch (DriverException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void disconnect() {
        if (this.lastWindowUpdateCommand != null) {
            try {
                this.lastWindowUpdateCommand.disableTracing();
            }
            catch (DriverException e) {
                throw new RuntimeException(e);
            }
        }
        super.disconnect();
    }

    public void beginTransaction() {
        this.inTransaction = true;
    }

    public void commitTransaction() {
        this.session.execute((Statement)this.batchCommand);
        this.batchCommand.clear();
        this.inTransaction = false;
    }

    public void rollbackTransaction() {
        this.batchCommand.clear();
        this.inTransaction = false;
    }

    public boolean isInTransaction() {
        return this.inTransaction;
    }

    public long getCommittedWindowId(String appId, int operatorId) {
        try {
            BoundStatement boundStatement = new BoundStatement(this.lastWindowFetchCommand);
            this.lastWindowFetchStatement = boundStatement.bind(new Object[]{appId, operatorId});
            long lastWindow = -1L;
            ResultSet resultSet = this.session.execute(this.lastWindowFetchStatement);
            if (!resultSet.isExhausted()) {
                lastWindow = resultSet.one().getLong(0);
            }
            this.lastWindowFetchCommand.disableTracing();
            return lastWindow;
        }
        catch (DriverException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void storeCommittedWindowId(String appId, int operatorId, long windowId) {
        try {
            BoundStatement boundStatement = new BoundStatement(this.lastWindowUpdateCommand);
            this.lastWindowUpdateStatement = boundStatement.bind(new Object[]{windowId, appId, operatorId});
            this.batchCommand.add(this.lastWindowUpdateStatement);
        }
        catch (DriverException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeCommittedWindowId(String appId, int operatorId) {
        try {
            BoundStatement boundStatement = new BoundStatement(this.lastWindowDeleteCommand);
            this.lastWindowDeleteStatement = boundStatement.bind(new Object[]{appId, operatorId});
            this.session.execute(this.lastWindowDeleteStatement);
            this.lastWindowDeleteCommand.disableTracing();
        }
        catch (DriverException e) {
            throw new RuntimeException(e);
        }
    }
}

