/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.DowngradingConsistencyRetryPolicy;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class ConnectionStateManager
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = -6024334738016015213L;
    private static final long DEFAULT_MAX_DELAY_MS = 30000L;
    private static final long DEFAULT_BASE_DELAY_MS = 10000L;
    private final String clusterName;
    private final String dcName;
    private final String seedNodesStr;
    private final long baseDelayMs;
    private final long maxDelayMs;
    private final transient LoadBalancingPolicy loadBalancingPolicy;
    private final transient RetryPolicy retryPolicy;
    private final transient QueryOptions queryOptions;
    private final transient ReconnectionPolicy reconnectionPolicy;
    private final transient ProtocolVersion protocolVersion;
    private transient Logger LOG = LoggerFactory.getLogger(ConnectionStateManager.class);
    private transient Cluster cluster;
    private transient Session session;
    private String keyspaceName;
    private String tableName;
    private int defaultTtlInSecs;
    private ConsistencyLevel defaultConsistencyLevel;
    private boolean isTTLSet = false;

    private ConnectionStateManager(ConnectionBuilder connectionBuilder) {
        Preconditions.checkNotNull((Object)connectionBuilder, (Object)"Connection Builder passed in as Null");
        Preconditions.checkNotNull((Object)connectionBuilder.clusterName, (Object)"Cluster Name not set for Cassandra");
        Preconditions.checkNotNull((Object)connectionBuilder.dcName, (Object)"DataCenter Name not set for Cassandra");
        Preconditions.checkNotNull((Object)connectionBuilder.seedNodesStr, (Object)"Seed nodes not set for Cassandra. Pattern is host1:port;host2:port");
        Preconditions.checkNotNull((Object)connectionBuilder.keyspaceName, (Object)"Keyspace Name not set for Cassandra");
        Preconditions.checkNotNull((Object)connectionBuilder.tableName, (Object)"Table Name not set for Cassandra");
        this.clusterName = connectionBuilder.clusterName;
        this.dcName = connectionBuilder.dcName;
        this.seedNodesStr = connectionBuilder.seedNodesStr;
        this.keyspaceName = connectionBuilder.keyspaceName;
        this.tableName = connectionBuilder.tableName;
        this.maxDelayMs = connectionBuilder.maxDelayMs != null ? connectionBuilder.maxDelayMs : 30000L;
        this.baseDelayMs = connectionBuilder.baseDelayMs != null ? connectionBuilder.baseDelayMs : 10000L;
        if (connectionBuilder.defaultTtlInSecs != null) {
            this.defaultTtlInSecs = connectionBuilder.defaultTtlInSecs;
            this.isTTLSet = true;
        }
        this.defaultConsistencyLevel = connectionBuilder.defaultConsistencyLevel != null ? connectionBuilder.defaultConsistencyLevel : ConsistencyLevel.LOCAL_QUORUM;
        this.loadBalancingPolicy = connectionBuilder.loadBalancingPolicy != null ? connectionBuilder.loadBalancingPolicy : new TokenAwarePolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().withLocalDc(this.dcName).build());
        this.retryPolicy = connectionBuilder.retryPolicy != null ? connectionBuilder.retryPolicy : DowngradingConsistencyRetryPolicy.INSTANCE;
        this.queryOptions = connectionBuilder.queryOptions != null ? connectionBuilder.queryOptions : new QueryOptions().setConsistencyLevel(this.defaultConsistencyLevel);
        this.reconnectionPolicy = connectionBuilder.reconnectionPolicy != null ? connectionBuilder.reconnectionPolicy : new ExponentialReconnectionPolicy(this.baseDelayMs, this.maxDelayMs);
        this.protocolVersion = connectionBuilder.protocolVersion != null ? connectionBuilder.protocolVersion : ProtocolVersion.NEWEST_SUPPORTED;
        this.establishSessionWithPolicies();
    }

    public static ConnectionBuilder withNewBuilder() {
        return new ConnectionBuilder();
    }

    private void establishSessionWithPolicies() {
        Cluster.Builder clusterBuilder = Cluster.builder();
        String[] seedNodesSplit = this.seedNodesStr.split(";");
        ArrayList<InetAddress> allSeeds = new ArrayList<InetAddress>();
        HashSet<String> allKnownPorts = new HashSet<String>();
        for (String seedNode : seedNodesSplit) {
            String[] nodeAndPort = seedNode.split(":");
            if (nodeAndPort.length > 1) {
                allKnownPorts.add(nodeAndPort[1]);
            }
            try {
                allSeeds.add(InetAddress.getByName(nodeAndPort[0]));
            }
            catch (UnknownHostException e) {
                this.LOG.error(" Error while trying to initialize the seed brokers for the cassandra cluster " + e.getMessage(), (Throwable)e);
            }
        }
        clusterBuilder = clusterBuilder.addContactPoints(allSeeds);
        clusterBuilder.withClusterName(this.clusterName).withLoadBalancingPolicy(this.loadBalancingPolicy).withRetryPolicy(this.retryPolicy).withQueryOptions(this.queryOptions).withReconnectionPolicy(this.reconnectionPolicy);
        if (allKnownPorts.size() > 0) {
            int shortlistedPort = Integer.parseInt((String)allKnownPorts.iterator().next());
            clusterBuilder = clusterBuilder.withPort(shortlistedPort);
        }
        this.cluster = clusterBuilder.build();
        Metadata metadata = this.cluster.getMetadata();
        this.LOG.info("Connected to cluster: \n" + metadata.getClusterName());
        for (Host host : metadata.getAllHosts()) {
            this.LOG.info(String.format("Datacenter: %s; Host: %s; Rack: %s\n", host.getDatacenter(), host.getAddress(), host.getRack()));
        }
        this.session = this.cluster.connect(this.keyspaceName);
    }

    @Override
    public void close() {
        if (this.session != null) {
            this.session.close();
        }
        if (this.cluster != null) {
            this.cluster.close();
        }
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    public void setKeyspaceName(String keyspaceName) {
        this.keyspaceName = keyspaceName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public int getDefaultTtlInSecs() {
        return this.defaultTtlInSecs;
    }

    public void setDefaultTtlInSecs(int defaultTtlInSecs) {
        this.defaultTtlInSecs = defaultTtlInSecs;
    }

    public boolean isTTLSet() {
        return this.isTTLSet;
    }

    public void setTTLSet(boolean TTLSet) {
        this.isTTLSet = TTLSet;
    }

    public static class ConnectionBuilder {
        private String clusterName;
        private String dcName;
        private String seedNodesStr;
        private Long baseDelayMs;
        private Long maxDelayMs;
        private String keyspaceName;
        private String tableName;
        private Integer defaultTtlInSecs;
        private ConsistencyLevel defaultConsistencyLevel;
        private LoadBalancingPolicy loadBalancingPolicy;
        private RetryPolicy retryPolicy;
        private QueryOptions queryOptions;
        private ReconnectionPolicy reconnectionPolicy;
        private ProtocolVersion protocolVersion;
        public static final String CLUSTER_NAME_IN_PROPS_FILE = "cluster.name";
        public static final String DC_NAME_IN_PROPS_FILE = "dc.name";
        public static final String KEYSPACE_NAME_IN_PROPS_FILE = "keyspace.name";
        public static final String TABLE_NAME_IN_PROPS_FILE = "table.name";
        public static final String SEEDNODES_IN_PROPS_FILE = "seednodes";

        public ConnectionBuilder withClusterNameAs(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public ConnectionBuilder withDCNameAs(String dcName) {
            this.dcName = dcName;
            return this;
        }

        public ConnectionBuilder withSeedNodes(String seedNodesStr) {
            this.seedNodesStr = seedNodesStr;
            return this;
        }

        public ConnectionBuilder withBaseDelayMillis(long baseDelayMillis) {
            this.baseDelayMs = baseDelayMillis;
            return this;
        }

        public ConnectionBuilder withMaxDelayMillis(long maxDelayMillis) {
            this.maxDelayMs = maxDelayMillis;
            return this;
        }

        public ConnectionBuilder withKeySpaceNameAs(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public ConnectionBuilder withTableNameAs(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public ConnectionBuilder withdefaultTTL(Integer defaultTtlInSecs) {
            this.defaultTtlInSecs = defaultTtlInSecs;
            return this;
        }

        public ConnectionBuilder withdefaultConsistencyLevel(ConsistencyLevel consistencyLevel) {
            this.defaultConsistencyLevel = consistencyLevel;
            return this;
        }

        public ConnectionBuilder withLoadBalancingPolicy(LoadBalancingPolicy loadBalancingPolicy) {
            this.loadBalancingPolicy = loadBalancingPolicy;
            return this;
        }

        public ConnectionBuilder withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public ConnectionBuilder withQueryOptions(QueryOptions queryOptions) {
            this.queryOptions = queryOptions;
            return this;
        }

        public ConnectionBuilder withReconnectionPolicy(ReconnectionPolicy reconnectionPolicy) {
            this.reconnectionPolicy = reconnectionPolicy;
            return this;
        }

        public ConnectionBuilder withProtocolVersion(ProtocolVersion protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        protected ConnectionStateManager initialize() {
            ConnectionStateManager operatorConnection = new ConnectionStateManager(this);
            return operatorConnection;
        }
    }
}

