/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.couchbase;

import com.couchbase.client.protocol.views.AbstractView;
import com.couchbase.client.protocol.views.Query;
import com.couchbase.client.protocol.views.Stale;
import com.couchbase.client.protocol.views.View;
import com.couchbase.client.protocol.views.ViewResponse;
import com.couchbase.client.protocol.views.ViewRow;
import com.datatorrent.api.Context;
import com.datatorrent.contrib.couchbase.CouchBaseStore;
import com.datatorrent.lib.db.AbstractStoreInputOperator;
import java.io.IOException;
import java.util.Iterator;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.classification.InterfaceStability;
import org.codehaus.jackson.map.ObjectMapper;

@InterfaceStability.Evolving
public class CouchBasePOJOInputOperator
extends AbstractStoreInputOperator<Object, CouchBaseStore> {
    private transient Class<?> className = null;
    private transient Query query;
    private final transient ObjectMapper objectMapper = new ObjectMapper();
    private String startkey;
    @Min(value=1L)
    private int limit = 10;
    private String startDocId;
    @NotNull
    private String designDocumentName;
    @NotNull
    private String viewName;
    private int skip = 0;
    private transient View view;
    private String outputClass;
    private boolean descending;

    public boolean isDescending() {
        return this.descending;
    }

    public void setDescending(boolean descending) {
        this.descending = descending;
    }

    public String getOutputClass() {
        return this.outputClass;
    }

    public void setOutputClass(String outputClass) {
        this.outputClass = outputClass;
    }

    public String getStartDocId() {
        return this.startDocId;
    }

    public void setStartDocId(String startDocId) {
        this.startDocId = startDocId;
    }

    public String getDesignDocumentName() {
        return this.designDocumentName;
    }

    public void setDesignDocumentName(String designDocumentName) {
        this.designDocumentName = designDocumentName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getStartkey() {
        return this.startkey;
    }

    public void setStartkey(String startkey) {
        this.startkey = startkey;
    }

    public CouchBasePOJOInputOperator() {
        this.store = new CouchBaseStore();
    }

    public void setup(Context.OperatorContext context) {
        super.setup(context);
        try {
            this.className = Class.forName(this.outputClass);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        this.view = ((CouchBaseStore)this.store).getInstance().getView(this.designDocumentName, this.viewName);
        this.query = new Query();
        this.query.setStale(Stale.FALSE);
        this.query.setIncludeDocs(true);
        this.query.setLimit(this.limit);
        this.query.setDescending(this.descending);
    }

    public void emitTuples() {
        if (this.startkey != null) {
            this.query.setRangeStart(this.startkey);
        }
        if (this.skip == 1) {
            this.query.setSkip(this.skip);
        }
        ViewResponse result = ((CouchBaseStore)this.store).getInstance().query((AbstractView)this.view, this.query);
        Iterator iterRow = result.iterator();
        while (iterRow.hasNext()) {
            ViewRow row = (ViewRow)iterRow.next();
            Object document = row.getDocument();
            Object outputObj = null;
            try {
                outputObj = this.objectMapper.readValue(document.toString(), this.className);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            this.outputPort.emit(outputObj);
            if (iterRow.hasNext()) continue;
            this.startkey = row.getKey();
            this.skip = 1;
        }
    }
}

