/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.couchdb;

import com.datatorrent.api.Context;
import com.datatorrent.contrib.couchdb.CouchDbStore;
import com.datatorrent.lib.db.AbstractStoreInputOperator;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.List;
import javax.validation.constraints.Min;
import org.ektorp.ViewQuery;
import org.ektorp.ViewResult;

public abstract class AbstractCouchDBInputOperator<T>
extends AbstractStoreInputOperator<T, CouchDbStore> {
    @Min(value=0L)
    private int pageSize = 100;
    private String nextPageKey = null;
    private boolean skip = false;
    private String startKey;

    public void setup(Context.OperatorContext t1) {
        this.nextPageKey = this.startKey;
    }

    public void emitTuples() {
        ViewQuery viewQuery = this.getViewQuery();
        if (this.pageSize > 0) {
            viewQuery.limit(this.pageSize);
        }
        if (this.nextPageKey != null) {
            viewQuery.startKey(this.nextPageKey);
        }
        if (this.skip) {
            viewQuery.skip(1);
        }
        ViewResult result = ((CouchDbStore)this.store).queryStore(viewQuery);
        List rows = result.getRows();
        try {
            for (ViewResult.Row row : result.getRows()) {
                T tuple = this.getTuple(row);
                this.outputPort.emit(tuple);
            }
        }
        catch (Throwable cause) {
            Throwables.propagate((Throwable)cause);
        }
        if (rows.size() > 0) {
            this.nextPageKey = ((ViewResult.Row)rows.get(rows.size() - 1)).getKey();
            this.skip = true;
        }
    }

    public abstract ViewQuery getViewQuery();

    public abstract T getTuple(ViewResult.Row var1) throws IOException;

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getStartKey() {
        return this.startKey;
    }

    public void setStartKey(String startKey) {
        this.startKey = startKey;
    }
}

