/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.elasticsearch;

import com.datatorrent.lib.db.Connectable;
import java.io.IOException;
import javax.validation.constraints.NotNull;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public class ElasticSearchConnectable
implements Connectable {
    @NotNull
    protected String hostName;
    @NotNull
    protected int port;
    protected transient TransportClient client;

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostname) {
        this.hostName = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void connect() throws IOException {
        this.client = new TransportClient();
        this.client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(this.hostName, this.port));
    }

    public void disconnect() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }

    public boolean isConnected() {
        if (this.client != null) {
            return this.client.connectedNodes().size() != 0;
        }
        return false;
    }
}

