/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.elasticsearch;

import com.datatorrent.api.Context;
import com.datatorrent.contrib.elasticsearch.AbstractElasticSearchInputOperator;
import com.datatorrent.contrib.elasticsearch.ElasticSearchConnectable;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.search.SearchHit;

public abstract class ElasticSearchMapInputOperator<T extends Map<String, Object>>
extends AbstractElasticSearchInputOperator<T, ElasticSearchConnectable> {
    @NotNull
    protected String indexName;
    @NotNull
    protected String type;

    public ElasticSearchMapInputOperator() {
        this.store = new ElasticSearchConnectable();
    }

    @Override
    public void setup(Context.OperatorContext t1) {
        super.setup(t1);
        this.searchRequestBuilder.setIndices(new String[]{this.indexName}).setTypes(new String[]{this.type}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH);
    }

    @Override
    protected T convertToTuple(SearchHit hit) {
        Map tuple = hit.getSource();
        return (T)tuple;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }
}

