/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.elasticsearch;

import com.datatorrent.contrib.elasticsearch.ElasticSearchConnectable;
import com.datatorrent.netlet.util.DTThrowable;
import java.io.IOException;
import org.elasticsearch.action.percolate.PercolateRequestBuilder;
import org.elasticsearch.action.percolate.PercolateResponse;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.QueryBuilder;

public class ElasticSearchPercolatorStore
extends ElasticSearchConnectable {
    private static final String PERCOLATOR_TYPE = ".percolator";

    ElasticSearchPercolatorStore(String hostName, int port) {
        this.setHostName(hostName);
        this.setPort(port);
    }

    public void registerPercolateQuery(String indexName, String queryName, QueryBuilder queryBuilder) {
        try {
            this.client.prepareIndex(indexName, PERCOLATOR_TYPE, queryName).setSource(XContentFactory.jsonBuilder().startObject().field("query", (ToXContent)queryBuilder).endObject()).setRefresh(true).execute().actionGet();
        }
        catch (IOException e) {
            DTThrowable.rethrow((Exception)e);
        }
    }

    public PercolateResponse percolate(String[] indexNames, String documentType, Object tuple) {
        try {
            XContentBuilder docBuilder = XContentFactory.jsonBuilder().startObject();
            docBuilder.field("doc").startObject();
            docBuilder.field("content", tuple);
            docBuilder.endObject();
            docBuilder.endObject();
            return (PercolateResponse)((PercolateRequestBuilder)this.client.preparePercolate().setIndices(indexNames)).setDocumentType(documentType).setSource(docBuilder).execute().actionGet();
        }
        catch (IOException e) {
            DTThrowable.rethrow((Exception)e);
            return null;
        }
    }
}

