/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.enrich;

import com.datatorrent.contrib.enrich.FSLoader;
import com.datatorrent.contrib.parser.CellProcessorBuilder;
import com.datatorrent.contrib.parser.DelimitedSchema;
import com.datatorrent.lib.util.ReusableStringReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.CsvMapReader;
import org.supercsv.prefs.CsvPreference;

@InterfaceStability.Evolving
public class DelimitedFSLoader
extends FSLoader {
    private transient CsvMapReader csvMapReader;
    private transient ReusableStringReader csvStringReader;
    @NotNull
    private String schema;
    private transient DelimitedSchema delimitedParserSchema;
    private transient CellProcessor[] processors;
    private transient String[] nameMapping;
    private transient String header;
    private transient CsvPreference preference;
    private boolean initialized;
    private static final Logger logger = LoggerFactory.getLogger(DelimitedFSLoader.class);

    @Override
    Map<String, Object> extractFields(String line) {
        if (!this.initialized) {
            this.init();
            this.initialized = true;
        }
        if (StringUtils.isBlank((String)line) || StringUtils.equals((String)line, (String)this.header)) {
            return null;
        }
        try {
            this.csvStringReader.open(line);
            return this.csvMapReader.read(this.nameMapping, this.processors);
        }
        catch (IOException e) {
            logger.error("Error parsing line{} Exception {}", (Object)line, (Object)e.getMessage());
            return null;
        }
    }

    private void init() {
        this.delimitedParserSchema = new DelimitedSchema(this.schema);
        this.preference = new CsvPreference.Builder(this.delimitedParserSchema.getQuoteChar(), this.delimitedParserSchema.getDelimiterChar(), this.delimitedParserSchema.getLineDelimiter()).build();
        this.nameMapping = this.delimitedParserSchema.getFieldNames().toArray(new String[this.delimitedParserSchema.getFieldNames().size()]);
        this.header = StringUtils.join((Object[])this.nameMapping, (String)((char)this.delimitedParserSchema.getDelimiterChar() + ""));
        this.processors = this.getProcessor(this.delimitedParserSchema.getFields());
        this.csvStringReader = new ReusableStringReader();
        this.csvMapReader = new CsvMapReader((Reader)this.csvStringReader, this.preference);
    }

    private CellProcessor[] getProcessor(List<DelimitedSchema.Field> fields) {
        CellProcessor[] processor = new CellProcessor[fields.size()];
        int fieldCount = 0;
        for (DelimitedSchema.Field field : fields) {
            processor[fieldCount++] = CellProcessorBuilder.getCellProcessor(field.getType(), field.getConstraints());
        }
        return processor;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }
}

