/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.enrich;

import com.datatorrent.api.Component;
import com.datatorrent.contrib.enrich.ReadOnlyBackup;
import com.datatorrent.lib.db.cache.CacheManager;
import com.datatorrent.lib.util.FieldInfo;
import com.esotericsoftware.kryo.NotNull;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public abstract class FSLoader
extends ReadOnlyBackup
implements Component<CacheManager.CacheContext> {
    @NotNull
    private String fileName;
    private transient Path filePath;
    private transient FileSystem fs;
    private transient boolean connected;
    private transient int numInitCachedLines = -1;
    private static final Logger logger = LoggerFactory.getLogger(FSLoader.class);

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Map<Object, Object> loadInitialData() {
        HashMap result;
        try (FSDataInputStream in = this.fs.open(this.filePath);
             BufferedReader bin = new BufferedReader(new InputStreamReader((InputStream)in));){
            String line;
            result = Maps.newHashMap();
            for (int linesCount = 0; (line = bin.readLine()) != null && (this.numInitCachedLines < 0 || linesCount < this.numInitCachedLines); ++linesCount) {
                try {
                    Map<String, Object> tuple = this.extractFields(line);
                    if (tuple == null || tuple.isEmpty()) continue;
                    result.put(this.getKey(tuple), this.getValue(tuple));
                    continue;
                }
                catch (Exception parseExp) {
                    throw new RuntimeException(parseExp);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        logger.debug("loading initial data, size: {}", (Object)result.size());
        return result;
    }

    abstract Map<String, Object> extractFields(String var1);

    private Object getValue(Map<String, Object> tuple) {
        ArrayList<Object> includeTuple = new ArrayList<Object>();
        for (FieldInfo s : this.includeFieldInfo) {
            includeTuple.add(tuple.get(s.getColumnName()));
        }
        return includeTuple;
    }

    private Object getKey(Map<String, Object> tuple) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (FieldInfo key : this.lookupFieldInfo) {
            list.add(tuple.get(key.getColumnName()));
        }
        return list;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Object get(Object key) {
        try (FSDataInputStream in = this.openWithRetryFsInputStream(this.filePath);
             BufferedReader bin = new BufferedReader(new InputStreamReader((InputStream)in));){
            String line;
            while ((line = bin.readLine()) != null) {
                try {
                    Map<String, Object> tuple = this.extractFields(line);
                    if (tuple == null || tuple.isEmpty() || !this.getKey(tuple).equals(key)) continue;
                    logger.debug("Found line in FS {}", this.getValue(tuple));
                    Object object = this.getValue(tuple);
                    return object;
                }
                catch (Exception parseExp) {
                    throw new RuntimeException(parseExp);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private FSDataInputStream openWithRetryFsInputStream(Path filePath) {
        FSDataInputStream in;
        try {
            in = this.fs.open(filePath);
        }
        catch (IOException e) {
            try {
                this.connect();
                in = this.fs.open(filePath);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return in;
    }

    public List<Object> getAll(List<Object> keys) {
        return null;
    }

    public void connect() throws IOException {
        Configuration conf = new Configuration();
        this.filePath = new Path(this.fileName);
        this.fs = FileSystem.newInstance((URI)this.filePath.toUri(), (Configuration)conf);
        if (!this.fs.isFile(this.filePath)) {
            throw new IOException("Provided path " + this.fileName + " is not a file");
        }
        this.connected = true;
    }

    public void disconnect() throws IOException {
        if (this.fs != null) {
            this.fs.close();
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setup(CacheManager.CacheContext context) {
        if (context != null) {
            this.numInitCachedLines = (Integer)context.getValue(CacheManager.CacheContext.NUM_INIT_CACHED_LINES_ATTR);
        }
    }

    public void teardown() {
    }
}

