/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.enrich;

import com.datatorrent.contrib.enrich.FSLoader;
import com.datatorrent.contrib.parser.AbstractCsvParser;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import com.univocity.parsers.fixed.FixedWidthFields;
import com.univocity.parsers.fixed.FixedWidthFormat;
import com.univocity.parsers.fixed.FixedWidthParser;
import com.univocity.parsers.fixed.FixedWidthParserSettings;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class FixedWidthFSLoader
extends FSLoader {
    private transient List<FixedWidthField> fields;
    private boolean hasHeader;
    @NotNull
    private String fieldDescription;
    private transient String[] header;
    private char padding = (char)32;
    private transient FixedWidthParser fixedWidthParser;
    private transient boolean initialized;
    private static final Logger logger = LoggerFactory.getLogger(FixedWidthFSLoader.class);

    public boolean isHasHeader() {
        return this.hasHeader;
    }

    public void setHasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }

    public String getFieldDescription() {
        return this.fieldDescription;
    }

    public void setFieldDescription(String fieldDescription) {
        this.fieldDescription = fieldDescription;
    }

    public char getPadding() {
        return this.padding;
    }

    public void setPadding(char padding) {
        this.padding = padding;
    }

    @Override
    Map<String, Object> extractFields(String line) {
        if (!this.initialized) {
            this.init();
            this.initialized = true;
        }
        Object[] values = this.fixedWidthParser.parseLine(line);
        if (this.hasHeader && Arrays.deepEquals(values, this.header)) {
            return null;
        }
        HashMap map = Maps.newHashMap();
        int i = 0;
        for (FixedWidthField field : this.fields) {
            map.put(field.getName(), this.getValue(field, (String)values[i++]));
        }
        return map;
    }

    private void init() {
        this.fields = new ArrayList<FixedWidthField>();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<Integer> fieldWidth = new ArrayList<Integer>();
        for (String tmp : this.fieldDescription.split(",")) {
            String[] fieldTuple = tmp.split(":(?=([^\"]*\"[^\"]*\")*[^\"]*$)", -1);
            FixedWidthField field = new FixedWidthField();
            field.setName(fieldTuple[0]);
            field.setType(fieldTuple[1]);
            field.setWidth(Integer.parseInt(fieldTuple[2]));
            headers.add(fieldTuple[0]);
            fieldWidth.add(Integer.parseInt(fieldTuple[2]));
            if (field.getType() == AbstractCsvParser.FIELD_TYPE.DATE) {
                if (fieldTuple.length > 3) {
                    field.setDateFormat(fieldTuple[3].replace("\"", ""));
                } else {
                    logger.error("Date format is missing for the field {}", (Object)field.getName());
                    throw new RuntimeException("Missing date format");
                }
            }
            this.fields.add(field);
        }
        this.header = headers.toArray(new String[headers.size()]);
        int[] width = Ints.toArray(fieldWidth);
        FixedWidthFields lengths = new FixedWidthFields(this.header, width);
        FixedWidthParserSettings settings = new FixedWidthParserSettings(lengths);
        ((FixedWidthFormat)settings.getFormat()).setPadding(this.padding);
        this.fixedWidthParser = new FixedWidthParser(settings);
    }

    private Object getValue(FixedWidthField field, String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        switch (field.getType()) {
            case BOOLEAN: {
                return Boolean.parseBoolean(value);
            }
            case DOUBLE: {
                return Double.parseDouble(value);
            }
            case INTEGER: {
                return Integer.parseInt(value);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(value));
            }
            case LONG: {
                return Long.parseLong(value);
            }
            case SHORT: {
                return Short.parseShort(value);
            }
            case CHARACTER: {
                return Character.valueOf(value.charAt(0));
            }
            case DATE: {
                try {
                    return new SimpleDateFormat(field.getDateFormat()).parse(value);
                }
                catch (ParseException e) {
                    logger.error("Error parsing date for format {} and value {}", (Object)field.getDateFormat(), (Object)value);
                    throw new RuntimeException(e);
                }
            }
        }
        return value;
    }

    public static class FixedWidthField
    extends AbstractCsvParser.Field {
        int width;
        String dateFormat;

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        public void setDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }
    }
}

