/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.enrich;

import com.datatorrent.contrib.enrich.BackendLoader;
import com.datatorrent.lib.db.jdbc.JdbcStore;
import com.datatorrent.lib.util.FieldInfo;
import com.google.common.collect.Lists;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceStability.Evolving
public class JDBCLoader
extends JdbcStore
implements BackendLoader {
    protected String queryStmt;
    protected String tableName;
    protected transient List<FieldInfo> includeFieldInfo;
    protected transient List<FieldInfo> lookupFieldInfo;

    protected Object getQueryResult(Object key) {
        try {
            PreparedStatement getStatement = this.getConnection().prepareStatement(this.queryStmt);
            ArrayList keys = (ArrayList)key;
            for (int i = 0; i < keys.size(); ++i) {
                getStatement.setObject(i + 1, keys.get(i));
            }
            return getStatement.executeQuery();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected ArrayList<Object> getDataFrmResult(Object result) throws RuntimeException {
        try {
            ResultSet resultSet = (ResultSet)result;
            if (resultSet.next()) {
                ResultSetMetaData rsdata = resultSet.getMetaData();
                if (CollectionUtils.isEmpty(this.includeFieldInfo)) {
                    if (this.includeFieldInfo == null) {
                        this.includeFieldInfo = new ArrayList<FieldInfo>();
                    }
                    for (int i = 1; i <= rsdata.getColumnCount(); ++i) {
                        String columnName = rsdata.getColumnName(i);
                        this.includeFieldInfo.add(new FieldInfo(columnName, columnName, FieldInfo.SupportType.OBJECT));
                    }
                }
                ArrayList<Object> res = new ArrayList<Object>();
                for (FieldInfo f : this.includeFieldInfo) {
                    res.add(this.getConvertedData(resultSet.getObject(f.getColumnName()), f));
                }
                return res;
            }
            return null;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private Object getConvertedData(Object object, FieldInfo f) {
        if (f.getType().getJavaType() == object.getClass()) {
            return object;
        }
        logger.warn("Type mismatch seen for field {}, returning as it is", (Object)f.getColumnName());
        return null;
    }

    private String generateQueryStmt() {
        String stmt = "select * from " + this.tableName + " where ";
        boolean first = true;
        for (FieldInfo fieldInfo : this.lookupFieldInfo) {
            if (first) {
                first = false;
            } else {
                stmt = stmt + " and ";
            }
            stmt = stmt + fieldInfo.getColumnName() + " = ?";
        }
        logger.info("generateQueryStmt: {}", (Object)stmt);
        return stmt;
    }

    public String getQueryStmt() {
        return this.queryStmt;
    }

    public void setQueryStmt(String queryStmt) {
        this.queryStmt = queryStmt;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public void setFieldInfo(List<FieldInfo> lookupFieldInfo, List<FieldInfo> includeFieldInfo) {
        this.lookupFieldInfo = lookupFieldInfo;
        this.includeFieldInfo = includeFieldInfo;
        if (this.queryStmt == null || this.queryStmt.length() == 0) {
            this.queryStmt = this.generateQueryStmt();
        }
    }

    public Map<Object, Object> loadInitialData() {
        return null;
    }

    public Object get(Object key) {
        return this.getDataFrmResult(this.getQueryResult(key));
    }

    public List<Object> getAll(List<Object> keys) {
        ArrayList values = Lists.newArrayList();
        for (Object key : keys) {
            values.add(this.get(key));
        }
        return values;
    }

    public void put(Object key, Object value) {
        throw new UnsupportedOperationException("Not supported operation");
    }

    public void putAll(Map<Object, Object> m) {
        throw new UnsupportedOperationException("Not supported operation");
    }

    public void remove(Object key) {
        throw new UnsupportedOperationException("Not supported operation");
    }
}

