/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.enrich;

import com.datatorrent.api.AutoMetric;
import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.annotation.InputPortFieldAnnotation;
import com.datatorrent.api.annotation.OutputPortFieldAnnotation;
import com.datatorrent.contrib.enrich.AbstractEnricher;
import com.datatorrent.lib.util.FieldInfo;
import com.datatorrent.lib.util.PojoUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class POJOEnricher
extends AbstractEnricher<Object, Object> {
    private static final Logger logger = LoggerFactory.getLogger(POJOEnricher.class);
    protected Class<?> inputClass;
    protected Class<?> outputClass;
    private transient Map<PojoUtils.Getter, PojoUtils.Setter> fieldMap = new HashMap<PojoUtils.Getter, PojoUtils.Setter>();
    private transient List<PojoUtils.Setter> includeSetters = new ArrayList<PojoUtils.Setter>();
    private transient List<PojoUtils.Getter> lookupGetters = new ArrayList<PojoUtils.Getter>();
    @AutoMetric
    private int enrichedTupleCount;
    @AutoMetric
    private int errorTupleCount;
    @InputPortFieldAnnotation(schemaRequired=true)
    public final transient DefaultInputPort<Object> input = new DefaultInputPort<Object>(){

        public void setup(Context.PortContext context) {
            POJOEnricher.this.inputClass = (Class)context.getValue(Context.PortContext.TUPLE_CLASS);
        }

        public void process(Object object) {
            POJOEnricher.this.processTuple(object);
        }
    };
    @OutputPortFieldAnnotation(schemaRequired=true)
    public final transient DefaultOutputPort<Object> output = new DefaultOutputPort<Object>(){

        public void setup(Context.PortContext context) {
            POJOEnricher.this.outputClass = (Class)context.getValue(Context.PortContext.TUPLE_CLASS);
        }
    };
    public final transient DefaultOutputPort<Object> error = new DefaultOutputPort();

    protected void processTuple(Object object) {
        this.enrichTuple(object);
    }

    public void beginWindow(long windowId) {
        this.enrichedTupleCount = 0;
        this.errorTupleCount = 0;
    }

    @Override
    protected Object getKey(Object tuple) {
        ArrayList<Object> keyList = new ArrayList<Object>();
        for (PojoUtils.Getter lookupGetter : this.lookupGetters) {
            keyList.add(lookupGetter.get(tuple));
        }
        return keyList;
    }

    @Override
    protected Object convert(Object in, Object cached) {
        Object o;
        try {
            o = this.outputClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("Failed to create new instance of output POJO", (Throwable)e);
            ++this.errorTupleCount;
            this.error.emit(in);
            return null;
        }
        try {
            for (Map.Entry<PojoUtils.Getter, PojoUtils.Setter> entry : this.fieldMap.entrySet()) {
                entry.getValue().set(o, entry.getKey().get(in));
            }
        }
        catch (RuntimeException e) {
            logger.error("Failed to set the property. Continuing with default.", (Throwable)e);
            ++this.errorTupleCount;
            this.error.emit(in);
            return null;
        }
        if (cached == null) {
            return o;
        }
        ArrayList includeObjects = (ArrayList)cached;
        for (int i = 0; i < this.includeSetters.size(); ++i) {
            try {
                this.includeSetters.get(i).set(o, includeObjects.get(i));
                continue;
            }
            catch (RuntimeException e) {
                logger.error("Failed to set the property. Continuing with default.", (Throwable)e);
                ++this.errorTupleCount;
                this.error.emit(in);
                return null;
            }
        }
        return o;
    }

    @Override
    protected void emitEnrichedTuple(Object tuple) {
        this.output.emit(tuple);
        ++this.enrichedTupleCount;
    }

    @Override
    protected Class<?> getIncludeFieldType(String fieldName) {
        try {
            return this.outputClass.getDeclaredField(fieldName).getType();
        }
        catch (NoSuchFieldException e) {
            logger.warn("Failed to find given fieldName, returning object type", (Throwable)e);
            return Object.class;
        }
    }

    @Override
    protected Class<?> getLookupFieldType(String fieldName) {
        try {
            return this.inputClass.getDeclaredField(fieldName).getType();
        }
        catch (NoSuchFieldException e) {
            logger.warn("Failed to find given fieldName, returning object type", (Throwable)e);
            return Object.class;
        }
    }

    private PojoUtils.Setter generateSettersForField(Class<?> klass, String outputFieldName) throws NoSuchFieldException, SecurityException {
        Field f = klass.getDeclaredField(outputFieldName);
        Class c = ClassUtils.primitiveToWrapper(f.getType());
        return PojoUtils.createSetter(klass, (String)outputFieldName, (Class)c);
    }

    private PojoUtils.Getter generateGettersForField(Class<?> klass, String inputFieldName) throws NoSuchFieldException, SecurityException {
        Field f = klass.getDeclaredField(inputFieldName);
        Class c = ClassUtils.primitiveToWrapper(f.getType());
        return PojoUtils.createGetter(klass, (String)inputFieldName, (Class)c);
    }

    @Override
    public void activate(Context context) {
        super.activate(context);
        for (Field field : this.inputClass.getDeclaredFields()) {
            try {
                this.fieldMap.put(this.generateGettersForField(this.inputClass, field.getName()), this.generateSettersForField(this.outputClass, field.getName()));
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Unable to find field with name " + field.getName() + ", ignoring that field.", e);
            }
        }
        for (FieldInfo fieldInfo : this.includeFieldInfo) {
            try {
                this.includeSetters.add(this.generateSettersForField(this.outputClass, fieldInfo.getColumnName()));
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Given field name is not present in output POJO", e);
            }
        }
        for (FieldInfo fieldInfo : this.lookupFieldInfo) {
            try {
                this.lookupGetters.add(this.generateGettersForField(this.inputClass, fieldInfo.getColumnName()));
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Given lookup field is not present in POJO", e);
            }
        }
    }

    @Override
    public void setLookupFields(List<String> lookupFields) {
        super.setLookupFields(lookupFields);
    }

    @Override
    public void setIncludeFields(List<String> includeFields) {
        super.setIncludeFields(includeFields);
    }
}

