/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.geode;

import com.datatorrent.contrib.geode.RegionCreateFunction;
import com.datatorrent.lib.util.StorageAgentKeyValueStore;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeodeCheckpointStore
implements StorageAgentKeyValueStore,
Serializable {
    public static final String GET_KEYS_QUERY = "SELECT entry.key FROM /$[region}.entries entry WHERE entry.key LIKE '${operator.id}%'";
    private String geodeLocators;
    private String geodeRegionName;
    protected transient Kryo kryo;
    private transient ClientCache clientCache = null;
    private transient Region<String, byte[]> region = null;
    private static final long serialVersionUID = 8897644407674960149L;
    private static final Logger logger = LoggerFactory.getLogger(GeodeCheckpointStore.class);

    public String getGeodeRegionName() {
        return this.geodeRegionName;
    }

    public void setGeodeRegionName(String geodeRegionName) {
        this.geodeRegionName = geodeRegionName;
    }

    public GeodeCheckpointStore() {
        this.geodeLocators = null;
        this.kryo = null;
    }

    public GeodeCheckpointStore(String locatorString) {
        this.geodeLocators = locatorString;
        this.kryo = new Kryo();
    }

    private Kryo getKyro() {
        if (this.kryo == null) {
            this.kryo = new Kryo();
        }
        return this.kryo;
    }

    public String getGeodeLocators() {
        return this.geodeLocators;
    }

    public void setGeodeLocators(String geodeLocators) {
        this.geodeLocators = geodeLocators;
    }

    public void connect() throws IOException {
        ClientCacheFactory factory = new ClientCacheFactory();
        Map<String, String> locators = this.parseLocatorString(this.geodeLocators);
        if (locators.size() == 0) {
            throw new IllegalArgumentException("Invalid locator connection string " + this.geodeLocators);
        }
        for (Map.Entry<String, String> entry : locators.entrySet()) {
            factory.addPoolLocator(entry.getKey(), Integer.valueOf(entry.getValue()).intValue());
        }
        this.clientCache = factory.create();
    }

    private Region<String, byte[]> getGeodeRegion() throws IOException {
        if (this.clientCache == null) {
            this.connect();
        }
        if (this.region == null) {
            this.region = this.clientCache.getRegion(this.geodeRegionName);
            if (this.region == null) {
                this.createRegion();
                this.region = this.clientCache.createClientRegionFactory(ClientRegionShortcut.PROXY).create(this.geodeRegionName);
            }
        }
        return this.region;
    }

    public synchronized void createRegion() {
        RegionCreateFunction atcf = new RegionCreateFunction();
        ArrayList<Object> inputList = new ArrayList<Object>();
        inputList.add(this.geodeRegionName);
        inputList.add(true);
        Execution members = FunctionService.onServers((Pool)this.clientCache.getDefaultPool()).withArgs(inputList);
        members.execute(atcf.getId()).getResult();
    }

    public void disconnect() throws IOException {
        this.clientCache.close();
    }

    public boolean isConnected() {
        if (this.clientCache == null) {
            return false;
        }
        return !this.clientCache.isClosed();
    }

    public Object get(Object key) {
        try {
            byte[] obj = (byte[])this.getGeodeRegion().get((Object)((String)key));
            if (obj == null) {
                return null;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(obj);
            this.getKyro().setClassLoader(Thread.currentThread().getContextClassLoader());
            Input input = new Input((InputStream)byteArrayInputStream);
            return this.getKyro().readClassAndObject(input);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void put(Object key, Object value) {
        try {
            Output output = new Output(4096, Integer.MAX_VALUE);
            this.getKyro().writeClassAndObject(output, value);
            this.getGeodeRegion().put((Object)((String)key), (Object)output.getBuffer());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void remove(Object key) {
        try {
            this.getGeodeRegion().destroy((Object)((String)key));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getKeys(Object key) {
        List<String> keys = null;
        try {
            keys = this.queryIds((Integer)key);
            return keys;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> queryIds(int operatorId) throws IOException {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            QueryService queryService = this.clientCache.getQueryService();
            Query query = queryService.newQuery(GET_KEYS_QUERY.replace("$[region}", this.geodeRegionName).replace("${operator.id}", String.valueOf(operatorId)));
            logger.debug("executing query {} ", (Object)query.getQueryString());
            SelectResults results = (SelectResults)query.execute();
            Iterator iterator = results.iterator();
            while (iterator.hasNext()) {
                ids.add(String.valueOf(iterator.next()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ids;
    }

    public void setTableName(String tableName) {
        this.geodeRegionName = tableName;
    }

    private Map<String, String> parseLocatorString(String locatorConnString) {
        HashMap locators = Maps.newHashMap();
        for (String locator : locatorConnString.split(",")) {
            String[] parts = locator.split(":");
            if (parts.length <= 1 || parts[0].isEmpty() || parts[0] == "" || parts[1].isEmpty() || parts[1] == "") {
                throw new IllegalArgumentException("Wrong locator connection string : " + locatorConnString + "\n" + "Expected format locator1:locator1_port,locator2:locator2_port");
            }
            locators.put(parts[0], parts[1]);
        }
        return locators;
    }

    public List<Object> getAll(List<Object> keys) {
        return null;
    }

    public void putAll(Map<Object, Object> m) {
    }
}

