/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.hbase;

import com.datatorrent.contrib.hbase.AbstractHBaseOutputOperator;
import com.datatorrent.contrib.hbase.HBaseStore;
import com.datatorrent.netlet.util.DTThrowable;
import java.io.InterruptedIOException;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHBasePutOutputOperator<T>
extends AbstractHBaseOutputOperator<T> {
    private static final transient Logger logger = LoggerFactory.getLogger(AbstractHBasePutOutputOperator.class);

    public AbstractHBasePutOutputOperator() {
        this.store = new HBaseStore();
    }

    @Override
    public void processTuple(T tuple, HTable table) {
        Put put = this.operationPut(tuple);
        try {
            table.put(put);
        }
        catch (RetriesExhaustedWithDetailsException e) {
            logger.error("Could not output tuple", (Throwable)e);
            DTThrowable.rethrow((Exception)((Object)e));
        }
        catch (InterruptedIOException e) {
            logger.error("Could not output tuple", (Throwable)e);
            DTThrowable.rethrow((Exception)e);
        }
    }

    public abstract Put operationPut(T var1);
}

