/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.hbase;

import com.datatorrent.api.Context;
import com.datatorrent.api.Operator;
import com.datatorrent.contrib.hbase.AbstractHBaseWindowOutputOperator;
import com.datatorrent.contrib.hbase.HBaseWindowStore;
import com.datatorrent.netlet.util.DTThrowable;
import java.io.IOException;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHBaseWindowPutOutputOperator<T>
extends AbstractHBaseWindowOutputOperator<T> {
    private static final transient Logger logger = LoggerFactory.getLogger(AbstractHBaseWindowPutOutputOperator.class);
    private transient Operator.ProcessingMode mode;

    @Deprecated
    public Operator.ProcessingMode getMode() {
        return this.mode;
    }

    @Deprecated
    public void setMode(Operator.ProcessingMode mode) {
        this.mode = mode;
    }

    public AbstractHBaseWindowPutOutputOperator() {
        this.store = new HBaseWindowStore();
    }

    @Override
    public void processTuple(T tuple, HTable table) {
        try {
            Put put = this.operationPut(tuple);
            table.put(put);
        }
        catch (IOException e) {
            logger.error("Could not output tuple", (Throwable)e);
            DTThrowable.rethrow((Exception)e);
        }
    }

    public abstract Put operationPut(T var1) throws IOException;

    public void setup(Context.OperatorContext context) {
        this.mode = (Operator.ProcessingMode)context.getValue(Context.OperatorContext.PROCESSING_MODE);
        if (this.mode == Operator.ProcessingMode.EXACTLY_ONCE) {
            throw new RuntimeException("This operator only supports atmost once and atleast once processing modes");
        }
        super.setup(context);
    }
}

