/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.hbase;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.contrib.hbase.HBaseFieldInfo;
import com.datatorrent.contrib.hbase.HBaseFieldValueGenerator;
import com.datatorrent.contrib.hbase.HBaseScanOperator;
import com.datatorrent.lib.util.FieldValueGenerator;
import com.datatorrent.lib.util.PojoUtils;
import com.datatorrent.lib.util.TableInfo;
import java.util.List;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class HBasePOJOInputOperator
extends HBaseScanOperator<Object> {
    private TableInfo<HBaseFieldInfo> tableInfo;
    private String pojoTypeName;
    protected transient Class<?> pojoType;
    protected transient FieldValueGenerator<HBaseFieldInfo> fieldValueGenerator;
    protected transient BytesValueConverter valueConverter;
    private transient Scan scan;
    private transient PojoUtils.Setter<Object, String> rowSetter;
    public final transient DefaultOutputPort<Object> outputPort = new DefaultOutputPort<Object>(){

        public void setup(Context.PortContext context) {
            HBasePOJOInputOperator.this.pojoType = (Class)context.getAttributes().get(Context.PortContext.TUPLE_CLASS);
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(HBasePOJOInputOperator.class);

    @Override
    public void activate(Context context) {
        try {
            this.pojoType.newInstance();
            this.rowSetter = PojoUtils.createSetter(this.pojoType, (String)this.tableInfo.getRowOrIdExpression(), String.class);
            this.fieldValueGenerator = new HBaseFieldValueGenerator(this.pojoType, this.tableInfo.getFieldsInfo());
            this.valueConverter = new BytesValueConverter();
            this.scan = new Scan();
            super.activate(context);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected Object getTuple(Result result) {
        try {
            String readRow = Bytes.toString((byte[])result.getRow());
            if (readRow.equals(this.getLastReadRow())) {
                return null;
            }
            Object instance = this.pojoType.newInstance();
            this.rowSetter.set(instance, (Object)readRow);
            List cells = result.listCells();
            for (Cell cell : cells) {
                String columnName = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell));
                String columnFamily = Bytes.toString((byte[])CellUtil.cloneFamily((Cell)cell));
                byte[] value = CellUtil.cloneValue((Cell)cell);
                ((HBaseFieldValueGenerator)this.fieldValueGenerator).setColumnValue(instance, columnName, columnFamily, value, this.valueConverter);
            }
            this.setLastReadRow(readRow);
            return instance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Scan operationScan() {
        if (this.getLastReadRow() == null && this.getStartRow() == null) {
            if (this.scan == null) {
                this.scan = new Scan();
            }
        } else if (this.getEndRow() == null) {
            this.scan.setStartRow(Bytes.toBytes((String)(this.getLastReadRow() == null ? this.getStartRow() : this.getLastReadRow())));
        } else {
            this.scan.setStartRow(Bytes.toBytes((String)(this.getLastReadRow() == null ? this.getStartRow() : this.getLastReadRow())));
            this.scan.setStopRow(Bytes.toBytes((String)this.getEndRow()));
        }
        for (HBaseFieldInfo field : this.tableInfo.getFieldsInfo()) {
            this.scan.addColumn(Bytes.toBytes((String)field.getFamilyName()), Bytes.toBytes((String)field.getColumnName()));
        }
        return this.scan;
    }

    @Override
    protected void emitTuple(Object tuple) {
        this.outputPort.emit(tuple);
    }

    public TableInfo<HBaseFieldInfo> getTableInfo() {
        return this.tableInfo;
    }

    public void setTableInfo(TableInfo<HBaseFieldInfo> tableInfo) {
        this.tableInfo = tableInfo;
    }

    public String getPojoTypeName() {
        return this.pojoTypeName;
    }

    public void setPojoTypeName(String pojoTypeName) {
        this.pojoTypeName = pojoTypeName;
    }

    public static class BytesValueConverter
    implements FieldValueGenerator.ValueConverter<HBaseFieldInfo> {
        public Object convertValue(HBaseFieldInfo fieldInfo, Object value) {
            return fieldInfo.toValue((byte[])value);
        }
    }
}

