/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.hbase;

import com.datatorrent.lib.db.Connectable;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Map;
import javax.validation.constraints.Min;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseStore
implements Connectable {
    public static final String USER_NAME_SPECIFIER = "%USER_NAME%";
    private static final Logger logger = LoggerFactory.getLogger(HBaseStore.class);
    private String zookeeperQuorum;
    private int zookeeperClientPort;
    protected String tableName;
    protected String principal;
    protected String keytabPath;
    protected long reloginCheckInterval = 1800000L;
    protected transient Thread loginRenewer;
    private volatile transient boolean doRelogin;
    protected transient HTable table;
    protected String[] allowedTableNames;
    protected transient LoadingCache<String, HTable> tableCache;
    @Min(value=1L)
    protected int maxOpenTables = Integer.MAX_VALUE;
    protected transient Configuration configuration;

    public String getZookeeperQuorum() {
        return this.zookeeperQuorum;
    }

    public void setZookeeperQuorum(String zookeeperQuorum) {
        this.zookeeperQuorum = zookeeperQuorum;
    }

    public int getZookeeperClientPort() {
        return this.zookeeperClientPort;
    }

    public void setZookeeperClientPort(int zookeeperClientPort) {
        this.zookeeperClientPort = zookeeperClientPort;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getKeytabPath() {
        return this.keytabPath;
    }

    public void setKeytabPath(String keytabPath) {
        this.keytabPath = keytabPath;
    }

    public long getReloginCheckInterval() {
        return this.reloginCheckInterval;
    }

    public void setReloginCheckInterval(long reloginCheckInterval) {
        this.reloginCheckInterval = reloginCheckInterval;
    }

    public String[] getAllowedTableNames() {
        return this.allowedTableNames;
    }

    public void setAllowedTableNames(String[] allowedTableNames) {
        this.allowedTableNames = allowedTableNames;
    }

    public HTable getTable() {
        return this.table;
    }

    public HTable getTable(String tableName) {
        if (tableName == null || tableName.equals(this.tableName)) {
            return this.getTable();
        }
        try {
            return (HTable)this.tableCache.get((Object)tableName);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void flushTables() throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        if (this.table != null) {
            this.flushTable(this.table);
        }
        for (Map.Entry entry : this.tableCache.asMap().entrySet()) {
            this.flushTable((HTable)entry.getValue());
        }
    }

    protected void flushTable(HTable table) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        table.flushCommits();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void connect() throws IOException {
        if (this.principal != null && this.keytabPath != null) {
            String lprincipal = this.evaluateProperty(this.principal);
            String lkeytabPath = this.evaluateProperty(this.keytabPath);
            UserGroupInformation.loginUserFromKeytab((String)lprincipal, (String)lkeytabPath);
            this.doRelogin = true;
            this.loginRenewer = new Thread(new Runnable(){

                @Override
                public void run() {
                    block5: {
                        logger.debug("Renewer starting");
                        try {
                            while (HBaseStore.this.doRelogin) {
                                Thread.sleep(HBaseStore.this.reloginCheckInterval);
                                try {
                                    UserGroupInformation.getLoginUser().checkTGTAndReloginFromKeytab();
                                }
                                catch (IOException e) {
                                    logger.error("Error trying to relogin from keytab", (Throwable)e);
                                }
                            }
                        }
                        catch (InterruptedException e) {
                            if (!HBaseStore.this.doRelogin) break block5;
                            logger.warn("Renewer interrupted... stopping");
                        }
                    }
                    logger.debug("Renewer ending");
                }
            });
            this.loginRenewer.start();
        }
        this.configuration = HBaseConfiguration.create();
        if (this.zookeeperQuorum != null) {
            this.configuration.set("hbase.zookeeper.quorum", this.zookeeperQuorum);
        }
        if (this.zookeeperClientPort != 0) {
            this.configuration.set("hbase.zookeeper.property.clientPort", "" + this.zookeeperClientPort);
        }
        if (this.tableName != null) {
            this.table = this.connectTable(this.tableName);
        }
        CacheLoader<String, HTable> cacheLoader = new CacheLoader<String, HTable>(){

            public HTable load(String key) throws Exception {
                return HBaseStore.this.loadTable(key);
            }
        };
        RemovalListener<String, HTable> removalListener = new RemovalListener<String, HTable>(){

            public void onRemoval(RemovalNotification<String, HTable> notification) {
                HBaseStore.this.unloadTable((HTable)notification.getValue());
            }
        };
        int maxCacheSize = this.tableName == null ? this.maxOpenTables : this.maxOpenTables - 1;
        this.tableCache = CacheBuilder.newBuilder().maximumSize((long)maxCacheSize).removalListener((RemovalListener)removalListener).build((CacheLoader)cacheLoader);
    }

    protected HTable loadTable(String tableName) throws IOException {
        if (this.allowedTableNames != null && !ArrayUtils.contains((Object[])this.allowedTableNames, (Object)tableName)) {
            return null;
        }
        return this.connectTable(tableName);
    }

    protected void unloadTable(HTable table) {
        try {
            table.close();
        }
        catch (IOException e) {
            logger.warn("Could not close table", (Throwable)e);
        }
    }

    protected HTable connectTable(String tableName) throws IOException {
        HTable table = new HTable(this.configuration, tableName);
        table.setAutoFlushTo(false);
        return table;
    }

    private String evaluateProperty(String property) throws IOException {
        if (property.contains(USER_NAME_SPECIFIER)) {
            property = property.replaceAll(USER_NAME_SPECIFIER, UserGroupInformation.getLoginUser().getShortUserName());
        }
        return property;
    }

    public void disconnect() throws IOException {
        if (this.loginRenewer != null) {
            this.doRelogin = false;
            this.loginRenewer.interrupt();
            try {
                this.loginRenewer.join();
            }
            catch (InterruptedException e) {
                logger.warn("Unsuccessful waiting for renewer to finish. Proceeding to shutdown", (Throwable)e);
            }
        }
    }

    public boolean isConnected() {
        return false;
    }

    public int getMaxOpenTables() {
        return this.maxOpenTables;
    }

    public void setMaxOpenTables(int maxOpenTables) {
        this.maxOpenTables = maxOpenTables;
    }
}

