/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.hbase;

import com.datatorrent.contrib.hbase.HBaseStore;
import com.google.common.base.Throwables;
import java.io.InterruptedIOException;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputAdapter<T> {
    private static final Logger logger = LoggerFactory.getLogger(OutputAdapter.class);
    private HBaseStore store;
    private Driver<T> driver;

    public OutputAdapter(HBaseStore store, Driver<T> driver) {
        this.store = store;
        this.driver = driver;
    }

    public void processTuple(T tuple) {
        String tableName = this.driver.getTableName(tuple);
        HTable table = this.store.getTable(tableName);
        if (table == null) {
            logger.debug("No table found for tuple {}", tuple);
            this.driver.errorTuple(tuple);
            return;
        }
        this.driver.processTuple(tuple, table);
    }

    public void flushTuples() {
        try {
            this.store.flushTables();
        }
        catch (InterruptedIOException | RetriesExhaustedWithDetailsException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static interface Driver<T> {
        public void processTuple(T var1, HTable var2);

        public String getTableName(T var1);

        public void errorTuple(T var1);
    }
}

