/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.kafka;

import com.datatorrent.api.Context;
import com.datatorrent.api.Operator;
import java.util.Map;
import java.util.Properties;
import javax.validation.constraints.NotNull;
import kafka.javaapi.producer.Producer;
import kafka.producer.ProducerConfig;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKafkaOutputOperator<K, V>
implements Operator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractKafkaOutputOperator.class);
    private transient Producer<K, V> producer;
    @NotNull
    private String topic = "topic1";
    protected int sendCount;
    private String producerProperties = "";
    private Properties configProperties = new Properties();

    public Properties getConfigProperties() {
        return this.configProperties;
    }

    public void setConfigProperties(Properties configProperties) {
        this.configProperties = configProperties;
    }

    protected ProducerConfig createKafkaProducerConfig() {
        Properties prop = new Properties();
        for (String propString : this.producerProperties.split(",")) {
            if (!propString.contains("=")) continue;
            String[] keyVal = StringUtils.trim((String)propString).split("=");
            prop.put(StringUtils.trim((String)keyVal[0]), StringUtils.trim((String)keyVal[1]));
        }
        this.configProperties.putAll((Map<?, ?>)prop);
        return new ProducerConfig(this.configProperties);
    }

    public Producer<K, V> getProducer() {
        return this.producer;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setup(Context.OperatorContext context) {
        this.producer = new Producer(this.createKafkaProducerConfig());
    }

    public void teardown() {
        this.producer.close();
    }

    public void beginWindow(long windowId) {
    }

    public void endWindow() {
    }

    public String getProducerProperties() {
        return this.producerProperties;
    }

    public void setProducerProperties(String producerProperties) {
        this.producerProperties = producerProperties;
    }
}

