/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.kinesis;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.model.GetRecordsRequest;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.amazonaws.services.kinesis.model.GetShardIteratorResult;
import com.amazonaws.services.kinesis.model.Record;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import java.util.List;

public class KinesisUtil {
    private transient AmazonKinesisClient client = null;
    private static KinesisUtil instance = null;

    private KinesisUtil() {
    }

    public static KinesisUtil getInstance() {
        if (instance == null) {
            instance = new KinesisUtil();
        }
        return instance;
    }

    public void createKinesisClient(String accessKey, String secretKey, String endPoint) throws Exception {
        if (this.client == null) {
            try {
                this.client = new AmazonKinesisClient((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey));
                if (endPoint != null) {
                    this.client.setEndpoint(endPoint);
                }
            }
            catch (Exception e) {
                throw new AmazonClientException("Unable to load credentials", (Throwable)e);
            }
        }
    }

    public List<Shard> getShardList(String streamName) {
        assert (this.client != null) : "Illegal client";
        DescribeStreamRequest describeRequest = new DescribeStreamRequest();
        describeRequest.setStreamName(streamName);
        DescribeStreamResult describeResponse = this.client.describeStream(describeRequest);
        return describeResponse.getStreamDescription().getShards();
    }

    public List<Record> getRecords(String streamName, Integer recordsLimit, String shId, ShardIteratorType iteratorType, String seqNo) throws AmazonClientException {
        assert (this.client != null) : "Illegal client";
        try {
            GetShardIteratorRequest iteratorRequest = new GetShardIteratorRequest();
            iteratorRequest.setStreamName(streamName);
            iteratorRequest.setShardId(shId);
            iteratorRequest.setShardIteratorType(iteratorType);
            if (ShardIteratorType.AFTER_SEQUENCE_NUMBER.equals((Object)iteratorType) || ShardIteratorType.AT_SEQUENCE_NUMBER.equals((Object)iteratorType)) {
                iteratorRequest.setStartingSequenceNumber(seqNo);
            }
            GetShardIteratorResult iteratorResponse = this.client.getShardIterator(iteratorRequest);
            String iterator = iteratorResponse.getShardIterator();
            GetRecordsRequest getRequest = new GetRecordsRequest();
            getRequest.setLimit(recordsLimit);
            getRequest.setShardIterator(iterator);
            GetRecordsResult getResponse = this.client.getRecords(getRequest);
            return getResponse.getRecords();
        }
        catch (AmazonClientException e) {
            throw new RuntimeException(e);
        }
    }

    public AmazonKinesisClient getClient() {
        return this.client;
    }

    public void setClient(AmazonKinesisClient client) {
        this.client = client;
    }
}

