/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.mongodb;

import com.datatorrent.contrib.mongodb.MongoDBOutputOperator;
import com.mongodb.BasicDBObject;
import java.util.HashMap;
import java.util.Map;

public class MongoDBHashMapOutputOperator<T>
extends MongoDBOutputOperator<HashMap<String, T>> {
    public transient HashMap<String, String> propTableMap = new HashMap();
    public transient HashMap<String, String> propColumnMap = new HashMap();

    @Override
    public void setColumnMapping(String[] mapping) {
        for (String str : mapping) {
            String[] tokens = str.split("[:]");
            String[] subtok = tokens[1].split("[.]");
            String table = subtok[0];
            String column = subtok[1];
            String prop = tokens[0];
            String type = tokens[2];
            if (!this.tableList.contains(table)) {
                this.tableList.add(table);
            }
            this.propTableMap.put(prop, table);
            this.propColumnMap.put(prop, column);
        }
    }

    @Override
    public void processTuple(HashMap<String, T> tuple) {
        this.tableToDocument.clear();
        BasicDBObject doc = null;
        for (Map.Entry<String, T> entry : tuple.entrySet()) {
            String prop = entry.getKey();
            String table = this.propTableMap.get(prop);
            String column = this.propColumnMap.get(prop);
            doc = (BasicDBObject)this.tableToDocument.get(table);
            if (doc == null) {
                doc = new BasicDBObject();
                doc.put(column, entry.getValue());
            } else {
                doc.put(column, entry.getValue());
            }
            this.tableToDocument.put(table, doc);
        }
        this.processTupleCommon();
    }
}

