/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.mongodb;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.contrib.mongodb.MongoDBConnectable;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Min;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MongoDBOutputOperator<T>
extends MongoDBConnectable
implements Operator {
    private static final Logger logger = LoggerFactory.getLogger(MongoDBOutputOperator.class);
    protected static final int DEFAULT_BATCH_SIZE = 1000;
    @Min(value=1L)
    protected long batchSize = 1000L;
    protected transient ArrayList<String> tableList = new ArrayList();
    protected transient HashMap<String, BasicDBObject> tableToDocument = new HashMap();
    protected transient HashMap<String, List<DBObject>> tableToDocumentList = new HashMap();
    protected String maxWindowTable;
    protected transient DBCollection maxWindowCollection;
    protected transient long windowId;
    protected transient int operatorId;
    protected transient long lastWindowId;
    protected transient boolean ignoreWindow;
    protected String windowIdColumnName;
    protected String operatorIdColumnName;
    protected transient int tupleId;
    protected int queryFunction;
    public final transient DefaultInputPort<T> inputPort = new DefaultInputPort<T>(){

        public void process(T tuple) {
            if (MongoDBOutputOperator.this.ignoreWindow) {
                return;
            }
            try {
                MongoDBOutputOperator.this.processTuple(tuple);
            }
            catch (Exception ex) {
                throw new RuntimeException("Exception during process tuple", ex);
            }
        }
    };

    public abstract void processTuple(T var1);

    public void initLastWindowInfo() {
        this.maxWindowCollection = this.db.getCollection(this.maxWindowTable);
        BasicDBObject query = new BasicDBObject();
        query.put(this.operatorIdColumnName, (Object)this.operatorId);
        DBCursor cursor = this.maxWindowCollection.find((DBObject)query);
        if (cursor.hasNext()) {
            Object obj = cursor.next().get(this.windowIdColumnName);
            this.lastWindowId = (Long)obj;
        } else {
            BasicDBObject doc = new BasicDBObject();
            doc.put(this.windowIdColumnName, (Object)0L);
            doc.put(this.operatorIdColumnName, (Object)this.operatorId);
            this.maxWindowCollection.save((DBObject)doc);
        }
        logger.debug("last windowid: {}", (Object)this.lastWindowId);
    }

    public void beginWindow(long windowId) {
        this.windowId = windowId;
        this.tupleId = 1;
        if (windowId < this.lastWindowId) {
            this.ignoreWindow = true;
        } else if (windowId == this.lastWindowId) {
            this.ignoreWindow = false;
            BasicDBObject query = new BasicDBObject();
            ByteBuffer bb = ByteBuffer.allocate(12);
            bb.order(ByteOrder.BIG_ENDIAN);
            StringBuilder low = new StringBuilder();
            StringBuilder high = new StringBuilder();
            if (this.queryFunction == 1) {
                this.queryFunction1(bb, high, low);
            } else if (this.queryFunction == 2) {
                this.queryFunction2(bb, high, low);
            } else if (this.queryFunction == 3) {
                this.queryFunction3(bb, high, low);
            } else {
                throw new RuntimeException("unknown queryFunction type:" + this.queryFunction);
            }
            query.put("_id", (Object)new BasicDBObject("$gte", (Object)new ObjectId(low.toString())).append("$lte", (Object)new ObjectId(high.toString())));
            for (String table : this.tableList) {
                this.db.getCollection(table).remove((DBObject)query);
            }
        } else {
            this.ignoreWindow = false;
        }
    }

    public void endWindow() {
        if (this.ignoreWindow) {
            return;
        }
        BasicDBObject where = new BasicDBObject();
        where.put(this.operatorIdColumnName, (Object)this.operatorId);
        BasicDBObject value = new BasicDBObject();
        value.put(this.operatorIdColumnName, (Object)this.operatorId);
        value.put(this.windowIdColumnName, (Object)this.windowId);
        this.maxWindowCollection.update((DBObject)where, (DBObject)value);
        for (String table : this.tableList) {
            List<DBObject> docList = this.tableToDocumentList.get(table);
            this.db.getCollection(table).insert(docList);
        }
    }

    public void setup(Context.OperatorContext context) {
        this.operatorId = context.getId();
        try {
            this.mongoClient = new MongoClient(this.hostName);
            this.db = this.mongoClient.getDB(this.dataBase);
            if (this.userName != null && this.passWord != null) {
                this.db.authenticate(this.userName, this.passWord.toCharArray());
            }
            this.initLastWindowInfo();
            for (String table : this.tableList) {
                this.tableToDocumentList.put(table, new ArrayList());
                this.tableToDocument.put(table, new BasicDBObject());
            }
        }
        catch (UnknownHostException ex) {
            logger.debug(ex.toString());
        }
    }

    public abstract void setColumnMapping(String[] var1);

    public void teardown() {
    }

    public void processTupleCommon() {
        ByteBuffer bb = ByteBuffer.allocate(12);
        bb.order(ByteOrder.BIG_ENDIAN);
        if (this.queryFunction == 1) {
            this.insertFunction1(bb);
        } else if (this.queryFunction == 2) {
            this.insertFunction2(bb);
        } else if (this.queryFunction == 3) {
            this.insertFunction3(bb);
        } else {
            throw new RuntimeException("unknown insertFunction type:" + this.queryFunction);
        }
        StringBuilder objStr = new StringBuilder();
        for (byte b : bb.array()) {
            objStr.append(String.format("%02x", b & 0xFF));
        }
        BasicDBObject doc = null;
        for (Map.Entry<String, BasicDBObject> entry : this.tableToDocument.entrySet()) {
            String table = entry.getKey();
            doc = entry.getValue();
            doc.put("_id", (Object)new ObjectId(objStr.toString()));
            List<DBObject> docList = this.tableToDocumentList.get(table);
            docList.add((DBObject)doc);
            if ((long)this.tupleId % this.batchSize == 0L) {
                BasicDBObject where = new BasicDBObject();
                where.put(this.operatorIdColumnName, (Object)this.operatorId);
                BasicDBObject value = new BasicDBObject();
                value.put(this.operatorIdColumnName, (Object)this.operatorId);
                value.put(this.windowIdColumnName, (Object)this.windowId);
                this.maxWindowCollection.update((DBObject)where, (DBObject)value);
                this.db.getCollection(table).insert(docList);
                this.tableToDocumentList.put(table, new ArrayList());
                continue;
            }
            this.tableToDocumentList.put(table, docList);
        }
        ++this.tupleId;
    }

    public void queryFunction1(ByteBuffer bb, StringBuilder high, StringBuilder low) {
        bb.putLong(this.windowId);
        byte opId = (byte)this.operatorId;
        bb.put(opId);
        ByteBuffer lowbb = bb;
        lowbb.put((byte)0);
        lowbb.put((byte)0);
        lowbb.put((byte)0);
        for (byte b : lowbb.array()) {
            low.append(String.format("02x", b & 0xFF));
        }
        ByteBuffer highbb = bb;
        highbb.put((byte)-1);
        highbb.put((byte)-1);
        highbb.put((byte)-1);
        for (byte b : highbb.array()) {
            high.append(String.format("02x", b & 0xFF));
        }
    }

    public void queryFunction2(ByteBuffer bb, StringBuilder high, StringBuilder low) {
        int baseSec = (int)(this.windowId >> 32);
        bb.putInt(baseSec);
        short winId = (short)(this.windowId & 0xFFFFL);
        bb.putShort(winId);
        Integer operId = this.operatorId;
        for (int i = 0; i < 3; ++i) {
            byte num = (byte)(operId >> 8 * (2 - i));
            bb.put(num);
        }
        ByteBuffer lowbb = bb.duplicate();
        lowbb.put((byte)0);
        lowbb.put((byte)0);
        lowbb.put((byte)0);
        for (byte b : lowbb.array()) {
            low.append(String.format("%02x", b & 0xFF));
        }
        ByteBuffer highbb = bb.duplicate();
        highbb.put((byte)-1);
        highbb.put((byte)-1);
        highbb.put((byte)-1);
        for (byte b : highbb.array()) {
            high.append(String.format("%02x", b & 0xFF));
        }
    }

    public void queryFunction3(ByteBuffer bb, StringBuilder high, StringBuilder low) {
        int baseSec = (int)(this.windowId >> 32);
        bb.putInt(baseSec);
        Integer operId = this.operatorId;
        for (int i = 0; i < 3; ++i) {
            byte num = (byte)(operId >> 8 * (2 - i));
            bb.put(num);
        }
        short winId = (short)(this.windowId & 0xFFFFL);
        bb.putShort(winId);
        ByteBuffer lowbb = bb.duplicate();
        lowbb.put((byte)0);
        lowbb.put((byte)0);
        lowbb.put((byte)0);
        for (byte b : lowbb.array()) {
            low.append(String.format("%02x", b & 0xFF));
        }
        ByteBuffer highbb = bb.duplicate();
        highbb.put((byte)-1);
        highbb.put((byte)-1);
        highbb.put((byte)-1);
        for (byte b : highbb.array()) {
            high.append(String.format("%02x", b & 0xFF));
        }
    }

    void insertFunction1(ByteBuffer bb) {
        bb.putLong(this.windowId);
        byte oid = (byte)this.operatorId;
        bb.put(oid);
        for (int i = 0; i < 3; ++i) {
            byte num = (byte)(this.tupleId >> 8 * (2 - i));
            bb.put(num);
        }
    }

    void insertFunction2(ByteBuffer bb) {
        byte num;
        int i;
        int baseSec = (int)(this.windowId >> 32);
        bb.putInt(baseSec);
        Integer operId = this.operatorId;
        for (i = 0; i < 3; ++i) {
            num = (byte)(operId >> 8 * (2 - i));
            bb.put(num);
        }
        bb.putShort((short)(this.windowId & 0xFFFFL));
        for (i = 0; i < 3; ++i) {
            num = (byte)(this.tupleId >> 8 * (2 - i));
            bb.put(num);
        }
    }

    void insertFunction3(ByteBuffer bb) {
        byte num;
        int i;
        int baseSec = (int)(this.windowId >> 32);
        bb.putInt(baseSec);
        short winId = (short)(this.windowId & 0xFFFFL);
        bb.putShort(winId);
        Integer operId = this.operatorId;
        for (i = 0; i < 3; ++i) {
            num = (byte)(operId >> 8 * (2 - i));
            bb.put(num);
        }
        for (i = 0; i < 3; ++i) {
            num = (byte)(this.tupleId >> 8 * (2 - i));
            bb.put(num);
        }
    }

    public void addTable(String table) {
        this.tableList.add(table);
    }

    public ArrayList<String> getTableList() {
        return this.tableList;
    }

    public void setQueryFunction(int queryFunction) {
        this.queryFunction = queryFunction;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(long batchSize) {
        this.batchSize = batchSize;
    }

    public String getMaxWindowTable() {
        return this.maxWindowTable;
    }

    public void setMaxWindowTable(String maxWindowTable) {
        this.maxWindowTable = maxWindowTable;
    }

    public String getWindowIdColumnName() {
        return this.windowIdColumnName;
    }

    public void setWindowIdColumnName(String windowIdColumnName) {
        this.windowIdColumnName = windowIdColumnName;
    }

    public String getOperatorIdColumnName() {
        return this.operatorIdColumnName;
    }

    public void setOperatorIdColumnName(String operatorIdColumnName) {
        this.operatorIdColumnName = operatorIdColumnName;
    }

    public long getLastWindowId() {
        return this.lastWindowId;
    }

    public void setLastWindowId(long lastWindowId) {
        this.lastWindowId = lastWindowId;
    }
}

