/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.mongodb;

import com.datatorrent.contrib.mongodb.MongoDBOutputOperator;
import com.datatorrent.lib.util.PojoUtils;
import com.mongodb.BasicDBObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceStability.Evolving
public class MongoDBPOJOOutputOperator
extends MongoDBOutputOperator<Object> {
    private final transient ArrayList<PojoUtils.Getter<Object, Object>> getterValues = new ArrayList();
    @NotNull
    private ArrayList<String> keys;
    @NotNull
    private ArrayList<String> expressions;
    private static final Map<String, Class<?>> mapPrimitives = new HashMap();
    private final transient Map<String, String[]> nestedKeys = new HashMap<String, String[]>();
    @NotNull
    private transient ArrayList<String> tablenames;
    @NotNull
    private ArrayList<String> fieldTypes;

    public ArrayList<String> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(ArrayList<String> expressions) {
        this.expressions = expressions;
    }

    public ArrayList<String> getFieldTypes() {
        return this.fieldTypes;
    }

    public void setFieldTypes(ArrayList<String> fieldTypes) {
        this.fieldTypes = fieldTypes;
    }

    public ArrayList<String> getKeys() {
        return this.keys;
    }

    public void setKeys(ArrayList<String> keys) {
        this.keys = keys;
    }

    public ArrayList<String> getTablenames() {
        return this.tablenames;
    }

    public void setTablenames(ArrayList<String> tablenames) {
        this.tablenames = tablenames;
    }

    private void processFirstTuple(Object tuple) {
        ArrayList classTypes = new ArrayList();
        for (String fieldType : this.fieldTypes) {
            if (mapPrimitives.containsKey(fieldType)) {
                classTypes.add(mapPrimitives.get(fieldType));
                continue;
            }
            try {
                classTypes.add(Class.forName(fieldType));
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        Class<?> fqcn = tuple.getClass();
        for (int i = 0; i < this.expressions.size(); ++i) {
            String table;
            String key = this.keys.get(i);
            this.getterValues.add((PojoUtils.Getter<Object, Object>)PojoUtils.createGetter(fqcn, (String)this.expressions.get(i), (Class)((Class)classTypes.get(i))));
            if (key.contains(".")) {
                this.nestedKeys.put(key, key.split("[.]"));
            }
            if (this.tableList.contains(table = this.tablenames.get(i))) continue;
            this.tableList.add(table);
        }
    }

    @Override
    public void processTuple(Object tuple) {
        this.tableToDocument.clear();
        BasicDBObject nestedDoc = null;
        if (this.getterValues.isEmpty()) {
            this.processFirstTuple(tuple);
        }
        for (int i = 0; i < this.keys.size(); ++i) {
            BasicDBObject doc;
            String key = this.keys.get(i);
            String table = this.tablenames.get(i);
            if (key.contains(".")) {
                String[] subKeys = this.nestedKeys.get(key);
                if (nestedDoc == null) {
                    nestedDoc = new BasicDBObject();
                }
                nestedDoc.put(subKeys[1], this.getterValues.get(i).get(tuple));
                doc = (BasicDBObject)this.tableToDocument.get(table);
                if (doc == null) {
                    doc = new BasicDBObject();
                }
                if (doc.containsField(subKeys[0])) {
                    doc.append(subKeys[0], (Object)nestedDoc);
                } else {
                    doc.put(subKeys[0], (Object)nestedDoc);
                }
            } else {
                doc = (BasicDBObject)this.tableToDocument.get(table);
                if (doc == null) {
                    doc = new BasicDBObject();
                }
                doc.put(key, this.getterValues.get(i).get(tuple));
            }
            this.tableToDocument.put(table, doc);
        }
        this.processTupleCommon();
    }

    @Override
    public void setColumnMapping(String[] mapping) {
    }

    static {
        mapPrimitives.put("boolean", Boolean.TYPE);
        mapPrimitives.put("char", Character.TYPE);
        mapPrimitives.put("short", Short.TYPE);
        mapPrimitives.put("int", Integer.TYPE);
        mapPrimitives.put("long", Long.TYPE);
        mapPrimitives.put("float", Float.TYPE);
        mapPrimitives.put("double", Double.TYPE);
    }
}

