/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.mqtt;

import com.datatorrent.api.Context;
import com.datatorrent.common.util.BaseOperator;
import com.datatorrent.contrib.mqtt.MqttClientConfig;
import javax.validation.constraints.NotNull;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractMqttOutputOperator
extends BaseOperator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMqttOutputOperator.class);
    @NotNull
    protected MqttClientConfig mqttClientConfig;
    protected transient MQTT client;
    protected transient BlockingConnection connection;

    public void setup(Context.OperatorContext context) {
        try {
            this.client = new MQTT();
            if (this.mqttClientConfig.getClientId() != null) {
                this.client.setClientId(this.mqttClientConfig.getClientId());
            }
            this.client.setCleanSession(this.mqttClientConfig.isCleanSession());
            this.client.setConnectAttemptsMax((long)this.mqttClientConfig.getConnectAttemptsMax());
            this.client.setHost(this.mqttClientConfig.getHost(), this.mqttClientConfig.getPort());
            this.client.setKeepAlive(this.mqttClientConfig.getKeepAliveInterval());
            if (this.mqttClientConfig.getPassword() != null) {
                this.client.setPassword(this.mqttClientConfig.getPassword());
            }
            if (this.mqttClientConfig.getUserName() != null) {
                this.client.setUserName(this.mqttClientConfig.getUserName());
            }
            if (this.mqttClientConfig.getWillMessage() != null) {
                this.client.setWillMessage(this.mqttClientConfig.getWillMessage());
                this.client.setWillQos(this.mqttClientConfig.getWillQos());
                this.client.setWillRetain(this.mqttClientConfig.isWillRetain());
                this.client.setWillTopic(this.mqttClientConfig.getWillTopic());
            }
            this.connection = this.client.blockingConnection();
            this.connection.connect();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void teardown() {
        try {
            this.connection.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MqttClientConfig getMqttClientConfig() {
        return this.mqttClientConfig;
    }

    public void setMqttClientConfig(MqttClientConfig mqttClientConfig) {
        this.mqttClientConfig = mqttClientConfig;
    }
}

