/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.parquet;

import com.datatorrent.api.Context;
import com.datatorrent.lib.io.fs.AbstractFileInputOperator;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;

@InterfaceStability.Evolving
public abstract class AbstractParquetFileReader<T>
extends AbstractFileInputOperator<T> {
    private transient ParquetReader<Group> reader;
    protected transient MessageType schema;
    protected String parquetSchema;

    public void setup(Context.OperatorContext context) {
        super.setup(context);
        this.schema = MessageTypeParser.parseMessageType((String)this.parquetSchema);
    }

    protected InputStream openFile(Path path) throws IOException {
        InputStream is = super.openFile(path);
        GroupReadSupport readSupport = new GroupReadSupport();
        readSupport.init(this.configuration, null, this.schema);
        this.reader = new ParquetReader(path, (ReadSupport)readSupport);
        return is;
    }

    protected T readEntity() throws IOException {
        Group group = (Group)this.reader.read();
        if (group != null) {
            return this.convertGroup(group);
        }
        return null;
    }

    protected abstract T convertGroup(Group var1);

    public String getParquetSchema() {
        return this.parquetSchema;
    }

    public void setParquetSchema(String parquetSchema) {
        this.parquetSchema = parquetSchema;
    }
}

